/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.extension;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.asn1.DERBoolean;
import com.cfca.util.pki.asn1.DERIA5String;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DERPrintableString;
import com.cfca.util.pki.asn1.DERUTF8String;
import com.cfca.util.pki.encoders.Base64;
import com.cfca.util.pki.extension.AbstractSelfDefExtension;
import java.math.BigInteger;

public class SelfDefExtension
extends AbstractSelfDefExtension {
    private String encoding = null;
    private String extensionValue = null;

    public SelfDefExtension() {
        this.critical = false;
    }

    public SelfDefExtension(DERObject obj, String type) {
        if (type == null) {
            this.extensionValue = null;
            return;
        }
        if (type.equals("Boolean")) {
            this.extensionValue = ((DERBoolean)obj).isTrue() ? "true" : "false";
        } else if (type.equals("IA5 String")) {
            this.extensionValue = ((DERIA5String)obj).getString();
        } else if (type.equals("Integer")) {
            this.extensionValue = String.valueOf(((DERInteger)obj).getValue().longValue());
        } else if (type.equals("Printable String")) {
            this.extensionValue = ((DERPrintableString)obj).getString();
        } else if (type.equals("User Defined")) {
            this.extensionValue = new String(Base64.encode(((DEROctetString)obj).getOctets()));
        } else if (type.equals("UTF-8 String")) {
            this.extensionValue = ((DERUTF8String)obj).getString();
        } else {
            this.extensionValue = null;
            return;
        }
    }

    public void setEncoding(String encoding) throws PKIException {
        if (encoding == null || encoding.equals("")) {
            throw new PKIException("8505850524", "\u6784\u9020\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u5931\u8d25,\u7f16\u7801\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setOID(String oid) throws PKIException {
        if (oid == null || oid.equals("")) {
            throw new PKIException("8505850513", "\u6784\u9020\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u5931\u8d25\uff0c\u6269\u5c55\u57dfOID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.OID = oid;
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public boolean getCritical() {
        return this.critical;
    }

    public void setExtensionValue(String value) throws PKIException {
        if (value == null || value.equals("")) {
            throw new PKIException("8505850525", "\u6784\u9020\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u5931\u8d25,\u6269\u5c55\u57df\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.extensionValue = value;
    }

    public String getExtensionValue() {
        return this.extensionValue;
    }

    public byte[] encode() throws PKIException {
        if (this.encoding == null) {
            throw new PKIException("850500", "\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u7f16\u7801\u7c7b\u578b\u4e3a\u7a7a");
        }
        byte[] value = null;
        if (this.encoding.equals("Boolean")) {
            DERBoolean derBoolean = new DERBoolean(Boolean.valueOf(this.extensionValue));
            DEROctetString octetValue = new DEROctetString(derBoolean.getDERObject());
            value = octetValue.getOctets();
            return value;
        }
        if (this.encoding.equals("IA5 String")) {
            DERIA5String ia5String = new DERIA5String(this.extensionValue);
            DEROctetString octetValue = new DEROctetString(ia5String.getDERObject());
            value = octetValue.getOctets();
            return value;
        }
        if (this.encoding.equals("Integer")) {
            DERInteger derInteger = new DERInteger(new BigInteger(this.extensionValue));
            DEROctetString octetValue = new DEROctetString(derInteger.getDERObject());
            value = octetValue.getOctets();
            return value;
        }
        if (this.encoding.equals("Printable String")) {
            DERPrintableString derPrintString = new DERPrintableString(this.extensionValue);
            DEROctetString octetValue = new DEROctetString(derPrintString.getDERObject());
            value = octetValue.getOctets();
            return value;
        }
        if (this.encoding.equals("User Defined")) {
            DEROctetString octetValue = new DEROctetString(Base64.decode(this.extensionValue));
            value = octetValue.getOctets();
            return value;
        }
        if (this.encoding.equals("UTF-8 String")) {
            DERUTF8String derUTF8String = new DERUTF8String(this.extensionValue);
            DEROctetString octetValue = new DEROctetString(derUTF8String.getDERObject());
            value = octetValue.getOctets();
            return value;
        }
        throw new PKIException("850501", "\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u7f16\u7801\u7c7b\u578b\u4e0d\u652f\u6301");
    }
}

