/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.ocsp;

import com.cfca.util.pki.PKIConstant;
import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.asn1.ASN1InputStream;
import com.cfca.util.pki.asn1.ASN1OctetString;
import com.cfca.util.pki.asn1.ASN1OutputStream;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERIA5String;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DEROutputStream;
import com.cfca.util.pki.asn1.ocsp.OCSPRequest;
import com.cfca.util.pki.asn1.ocsp.Request;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.asn1.x509.GeneralName;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.asn1.x509.X509Name;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.ocsp.Req;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class OCSPReq
implements X509Extension {
    private OCSPRequest req;

    public OCSPReq(OCSPRequest req) {
        this.req = req;
    }

    public OCSPReq(byte[] req) throws PKIException {
        this(new ASN1InputStream(req));
    }

    public OCSPReq(InputStream in) throws PKIException {
        this(new ASN1InputStream(in));
    }

    private OCSPReq(ASN1InputStream aIn) throws PKIException {
        try {
            this.req = OCSPRequest.getInstance(aIn.readObject());
        }
        catch (IllegalArgumentException e) {
            throw new PKIException("850801", "\u89e3\u6790OCSP\u8bf7\u6c42\u65f6\u6784\u9020\u8bf7\u6c42\u5931\u8d25", e);
        }
        catch (IOException e) {
            throw new PKIException("850801", "\u89e3\u6790OCSP\u8bf7\u6c42\u65f6\u6784\u9020\u8bf7\u6c42\u5931\u8d25", e);
        }
        catch (ClassCastException e) {
            throw new PKIException("850801", "\u89e3\u6790OCSP\u8bf7\u6c42\u65f6\u6784\u9020\u8bf7\u6c42\u5931\u8d25", e);
        }
    }

    public byte[] getTBSRequest() throws PKIException {
        try {
            return this.req.getTbsRequest().getEncoded();
        }
        catch (IOException e) {
            throw new PKIException("850817", "\u83b7\u5f97TBSRequest\u5931\u8d25", e);
        }
    }

    public int getVersion() {
        return this.req.getTbsRequest().getVersion().getValue().intValue() + 1;
    }

    public String getRequestorName() {
        GeneralName genName = GeneralName.getInstance(this.req.getTbsRequest().getRequestorName());
        if (genName == null) {
            return null;
        }
        return this.getStringName(genName);
    }

    private String getStringName(GeneralName genName) {
        int tag = genName.getTagNo();
        DEREncodable derObj = genName.getName();
        if (tag == 4) {
            X509Name name = X509Name.getInstance(derObj);
            return name.toString();
        }
        if (tag == 1 || tag == 2 || tag == 6) {
            DERIA5String dstr = (DERIA5String)derObj;
            return dstr.getString();
        }
        if (tag == 7) {
            ASN1OctetString oct = (ASN1OctetString)derObj;
            return new String(oct.getOctets());
        }
        if (tag == 8) {
            DERObjectIdentifier oid = (DERObjectIdentifier)derObj;
            return oid.getId();
        }
        return null;
    }

    public Req[] getRequestList() {
        ASN1Sequence seq = this.req.getTbsRequest().getRequestList();
        Req[] requests = new Req[seq.size()];
        int i = 0;
        while (i != requests.length) {
            requests[i] = new Req(Request.getInstance(seq.getObjectAt(i)));
            ++i;
        }
        return requests;
    }

    public X509Extensions getRequestExtensions() {
        return X509Extensions.getInstance(this.req.getTbsRequest().getRequestExtensions());
    }

    public String getSignatureAlgOID() {
        if (!this.isSigned()) {
            return null;
        }
        return this.req.getOptionalSignature().getSignatureAlgorithm().getObjectId().getId();
    }

    public byte[] getSignature() {
        if (!this.isSigned()) {
            return null;
        }
        return this.req.getOptionalSignature().getSignature().getBytes();
    }

    public X509Cert[] getCerts() throws PKIException {
        if (!this.isSigned()) {
            return null;
        }
        X509Cert[] chain = null;
        ArrayList<X509Cert> certs = new ArrayList<X509Cert>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        ASN1Sequence s = this.req.getOptionalSignature().getCerts();
        if (s != null) {
            Enumeration e = s.getObjects();
            while (e.hasMoreElements()) {
                try {
                    aOut.writeObject(e.nextElement());
                    certs.add(new X509Cert(new ByteArrayInputStream(bOut.toByteArray())));
                }
                catch (Exception ex) {
                    throw new PKIException("\u4eceOCSP\u8bf7\u6c42\u4e2d\u83b7\u5f97\u8bc1\u4e66\u5931\u8d25", "\u4eceOCSP\u8bf7\u6c42\u4e2d\u83b7\u5f97\u8bc1\u4e66\u5931\u8d25", ex);
                }
                bOut.reset();
            }
        }
        chain = certs.toArray(new X509Cert[certs.size()]);
        return chain;
    }

    public boolean isSigned() {
        return this.req.getOptionalSignature() != null;
    }

    public boolean verify(JKey key, Session session) throws PKIException {
        if (!this.isSigned()) {
            throw new PKIException("850803", "\u9a8c\u8bc1OCSP\u8bf7\u6c42\u7684\u7b7e\u540d\u5931\u8d25");
        }
        try {
            DERObjectIdentifier derOID = new DERObjectIdentifier(this.getSignatureAlgOID());
            if (!(derOID.equals(PKCSObjectIdentifiers.md2WithRSAEncryption) || derOID.equals(PKCSObjectIdentifiers.md5WithRSAEncryption) || derOID.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption))) {
                throw new PKIException("850400", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
            }
            String algName = (String)PKIConstant.oid2SigAlgName.get(derOID);
            Mechanism mechanism = new Mechanism(algName);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(this.req.getTbsRequest());
            return session.verifySign(mechanism, key, bOut.toByteArray(), this.getSignature());
        }
        catch (Exception e) {
            throw new PKIException("850803", "\u9a8c\u8bc1OCSP\u8bf7\u6c42\u7684\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    public byte[] getEncoded() throws PKIException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        try {
            aOut.writeObject(this.req);
        }
        catch (IOException ex) {
            throw new PKIException("850804", "\u83b7\u5f97OCSP\u8bf7\u6c42\u7684\u7f16\u7801\u5931\u8d25", ex);
        }
        return bOut.toByteArray();
    }

    public boolean hasUnsupportedCriticalExtension() {
        Set extns = this.getCriticalExtensionOIDs();
        return extns != null && !extns.isEmpty();
    }

    private Set getExtensionOIDs(boolean critical) {
        HashSet<String> set = new HashSet<String>();
        X509Extensions extensions = this.getRequestExtensions();
        if (extensions != null) {
            Enumeration e = extensions.oids();
            while (e.hasMoreElements()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
                com.cfca.util.pki.asn1.x509.X509Extension ext = extensions.getExtension(oid);
                if (critical != ext.isCritical()) continue;
                set.add(oid.getId());
            }
        }
        return set;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public byte[] getExtensionValue(String oid) {
        com.cfca.util.pki.asn1.x509.X509Extension ext;
        X509Extensions exts = this.getRequestExtensions();
        if (exts != null && (ext = exts.getExtension(new DERObjectIdentifier(oid))) != null) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            try {
                dOut.writeObject(ext.getValue());
                return bOut.toByteArray();
            }
            catch (Exception e) {
                throw new RuntimeException("error encoding " + e.toString());
            }
        }
        return null;
    }
}

