/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.pkcs;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.ASN1Set;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DEROutputStream;
import com.cfca.util.pki.asn1.DERSet;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.asn1.pkcs.pkcs7.ContentInfo;
import com.cfca.util.pki.asn1.pkcs.pkcs7.SignedData;
import com.cfca.util.pki.asn1.x509.X509CertificateStructure;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JCrypto;
import com.cfca.util.pki.encoders.Base64;
import com.cfca.util.pki.pkcs.PKCS12;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class P7B {
    public X509Cert[] parseP7b(ContentInfo contentInfo) throws PKIException {
        if (!contentInfo.getContentType().equals(PKCSObjectIdentifiers.signedData)) {
            throw new PKIException("850601", "\u89e3\u6790P7B\u8bc1\u4e66\u94fe\u7ed3\u6784\u5931\u8d25 \u8bc1\u4e66\u94fe\u7c7b\u578b\u4e0d\u5339\u914d " + contentInfo.getContentType().getId());
        }
        SignedData signedData = SignedData.getInstance(contentInfo.getContent());
        ASN1Set certSet = signedData.getCertificates();
        Enumeration enumeration = certSet.getObjects();
        Vector<X509Cert> v = new Vector<X509Cert>();
        X509Cert cert = null;
        while (enumeration.hasMoreElements()) {
            X509CertificateStructure certStruc = X509CertificateStructure.getInstance(enumeration.nextElement());
            cert = new X509Cert(certStruc);
            v.add(cert);
        }
        X509Cert[] certs = new X509Cert[v.size()];
        v.toArray(certs);
        return certs;
    }

    public X509Cert[] parseP7b(String fileName) throws PKIException {
        FileInputStream fin = null;
        byte[] data = null;
        try {
            fin = new FileInputStream(fileName);
            data = new byte[fin.available()];
            fin.read(data);
            fin.close();
        }
        catch (Exception ex) {
            throw new PKIException("850601", "\u89e3\u6790P7B\u8bc1\u4e66\u94fe\u7ed3\u6784\u5931\u8d25", ex);
        }
        return this.parseP7b(data);
    }

    public X509Cert[] parseP7b(InputStream ins) throws PKIException {
        try {
            byte[] content = new byte[ins.available()];
            ins.read(content);
            ins.close();
            return this.parseP7b(content);
        }
        catch (Exception ex) {
            throw new PKIException("850601", "\u89e3\u6790P7B\u8bc1\u4e66\u94fe\u7ed3\u6784\u5931\u8d25", ex);
        }
    }

    public X509Cert[] parseP7b(byte[] data) throws PKIException {
        boolean isB64 = Parser.isBase64Encode(data);
        if (isB64) {
            data = Parser.convertBase64(data);
            data = Base64.decode(data);
        }
        if (data[0] != 48) {
            throw new PKIException("850601", "\u89e3\u6790P7B\u8bc1\u4e66\u94fe\u7ed3\u6784\u5931\u8d25", new Exception("The P7B certification chain content error."));
        }
        try {
            ASN1Sequence sequence = (ASN1Sequence)Parser.writeBytes2DERObj(data);
            ContentInfo contentInfo = ContentInfo.getInstance(sequence);
            return this.parseP7b(contentInfo);
        }
        catch (Exception ex) {
            throw new PKIException("850601", "\u89e3\u6790P7B\u8bc1\u4e66\u94fe\u7ed3\u6784\u5931\u8d25", ex);
        }
    }

    public ContentInfo generateP7b(X509Cert[] certs) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        int i = 0;
        while (i < certs.length) {
            X509CertificateStructure certStruc = certs[i].getCertStructure();
            v.add(certStruc);
            ++i;
        }
        DERSet certSet = new DERSet(v);
        DERSet algs = new DERSet();
        DERSet signerInfos = new DERSet();
        ContentInfo ci = new ContentInfo(PKCSObjectIdentifiers.data, null);
        SignedData signedData = new SignedData(new DERInteger(1), algs, ci, certSet, null, signerInfos);
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, signedData);
        return contentInfo;
    }

    public void generateP7bFile(X509Cert[] certs, String fileName) throws PKIException {
        ContentInfo contentInfo = this.generateP7b(certs);
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            DEROutputStream dos = new DEROutputStream(fos);
            dos.writeObject(contentInfo.getDERObject());
            dos.close();
            fos.close();
        }
        catch (Exception ex) {
            throw new PKIException("850600", "\u4ea7\u751fP7B\u8bc1\u4e66\u94fe\u7ed3\u6784\u5931\u8d25", ex);
        }
    }

    public byte[] generateP7bData_DER(X509Cert[] certs) throws PKIException {
        ContentInfo contentInfo = this.generateP7b(certs);
        return Parser.writeDERObj2Bytes(contentInfo.getDERObject());
    }

    public byte[] generateP7bData_B64(X509Cert[] certs) throws PKIException {
        byte[] data = this.generateP7bData_DER(certs);
        data = Base64.encode(data);
        return data;
    }

    public static void main(String[] args) {
        try {
            JCrypto jcrypto = JCrypto.getInstance();
            jcrypto.initialize("JSOFT_LIB", null);
            PKCS12 p12 = new PKCS12();
            p12.load("C:/ccb.pfx");
            p12.decrypt("111".toCharArray());
            P7B p7b = new P7B();
            p7b.generateP7bFile(p12.getCerts(), "D:/test.p7b");
            X509Cert[] certs = p7b.parseP7b("D:/test.p7b");
            System.out.println(certs.length);
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
        }
    }
}

