/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.gm;

import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Integer;
import cn.com.infosec.asn1.ASN1Object;
import cn.com.infosec.asn1.ASN1Primitive;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.x9.ECNamedCurveTable;
import cn.com.infosec.asn1.x9.X9ECParameters;
import cn.com.infosec.crypto.engines.SM2Engine;
import cn.com.infosec.math.ec.ECCurve;
import cn.com.infosec.math.ec.ECPoint;
import java.math.BigInteger;

public class SM2Cipher
extends ASN1Object {
    private BigInteger XCoordinate;
    private BigInteger YCoordinate;
    private byte[] HASH;
    private byte[] CipherText;

    public SM2Cipher(ASN1Sequence seq) {
        this.XCoordinate = ASN1Integer.getInstance(seq.getObjectAt(0)).getValue();
        this.YCoordinate = ASN1Integer.getInstance(seq.getObjectAt(1)).getValue();
        this.HASH = DEROctetString.getInstance(seq.getObjectAt(2)).getOctets();
        this.CipherText = DEROctetString.getInstance(seq.getObjectAt(3)).getOctets();
    }

    public SM2Cipher(BigInteger XCoordinate, BigInteger YCoordinate, byte[] HASH, byte[] cipherText) {
        this.XCoordinate = XCoordinate;
        this.YCoordinate = YCoordinate;
        this.HASH = HASH;
        this.CipherText = cipherText;
    }

    public static SM2Cipher getInstance(Object o) {
        if (o instanceof SM2Cipher) {
            return (SM2Cipher)o;
        }
        if (o != null) {
            return new SM2Cipher(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public byte[] getCipherText() {
        return this.CipherText;
    }

    public byte[] assemblyEncryptedValue() {
        return this.assemblyEncryptedValue("sm2p256v1", SM2Engine.Mode.C1C3C2);
    }

    public byte[] assemblyEncryptedValue(SM2Engine.Mode mode) {
        return this.assemblyEncryptedValue("sm2p256v1", mode);
    }

    private byte[] assemblyEncryptedValue(String curveName, SM2Engine.Mode mode) {
        X9ECParameters sm2p256v1 = ECNamedCurveTable.getByName(curveName);
        ECCurve curve = sm2p256v1.getCurve();
        ECPoint ecPoint = curve.validatePoint(this.XCoordinate, this.YCoordinate);
        byte[] encodedPoint = ecPoint.getEncoded(false);
        int curveLength = (curve.getFieldSize() + 7) / 8;
        byte[] cipherText = new byte[curveLength * 2 + 1 + this.HASH.length + this.CipherText.length];
        System.arraycopy(encodedPoint, 0, cipherText, 0, encodedPoint.length);
        if (mode == SM2Engine.Mode.C1C3C2) {
            System.arraycopy(this.HASH, 0, cipherText, encodedPoint.length, this.HASH.length);
            System.arraycopy(this.CipherText, 0, cipherText, encodedPoint.length + this.HASH.length, this.CipherText.length);
            return cipherText;
        }
        if (mode == SM2Engine.Mode.C1C2C3) {
            System.arraycopy(this.CipherText, 0, cipherText, encodedPoint.length, this.CipherText.length);
            System.arraycopy(this.HASH, 0, cipherText, encodedPoint.length + this.CipherText.length, this.HASH.length);
            return cipherText;
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(this.XCoordinate));
        v.add(new ASN1Integer(this.YCoordinate));
        v.add(new DEROctetString(this.HASH));
        v.add(new DEROctetString(this.CipherText));
        return new DERSequence(v);
    }
}

