/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.gm;

import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Object;
import cn.com.infosec.asn1.ASN1Primitive;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERBitString;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.gm.SM2Cipher;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;

public class SM2EnvelopedKey
extends ASN1Object {
    private AlgorithmIdentifier symAlgID;
    private SM2Cipher symEncryptedKey;
    private byte[] Sm2PublicKey;
    private byte[] Sm2EncryptedPrivateKey;

    public SM2EnvelopedKey(ASN1Sequence seq) {
        this.symAlgID = AlgorithmIdentifier.getInstance(seq.getObjectAt(0));
        this.symEncryptedKey = SM2Cipher.getInstance(seq.getObjectAt(1));
        this.Sm2PublicKey = DERBitString.getInstance(seq.getObjectAt(2)).getOctets();
        this.Sm2EncryptedPrivateKey = DERBitString.getInstance(seq.getObjectAt(3)).getOctets();
    }

    public SM2EnvelopedKey(AlgorithmIdentifier symAlgID, SM2Cipher symEncryptedKey, byte[] sm2PublicKey, byte[] sm2EncryptedPrivateKey) {
        this.symAlgID = symAlgID;
        this.symEncryptedKey = symEncryptedKey;
        this.Sm2PublicKey = sm2PublicKey;
        this.Sm2EncryptedPrivateKey = sm2EncryptedPrivateKey;
    }

    public static SM2EnvelopedKey getInstance(Object o) {
        if (o instanceof SM2EnvelopedKey) {
            return (SM2EnvelopedKey)o;
        }
        if (o != null) {
            return new SM2EnvelopedKey(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public AlgorithmIdentifier getSymAlgID() {
        return this.symAlgID;
    }

    public SM2Cipher getSymEncryptedKey() {
        return this.symEncryptedKey;
    }

    public byte[] getSm2EncryptedPrivateKey() {
        return this.Sm2EncryptedPrivateKey;
    }

    public byte[] getSm2PublicKey() {
        return this.Sm2PublicKey;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.symAlgID);
        v.add(this.symEncryptedKey);
        v.add(new DERBitString(this.Sm2PublicKey));
        v.add(new DERBitString(this.Sm2EncryptedPrivateKey));
        return new DERSequence(v);
    }
}

