/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.gm;

import cn.com.infosec.asn1.ASN1ObjectIdentifier;
import cn.com.infosec.asn1.gm.GMObjectIdentifiers;
import cn.com.infosec.asn1.gm.SM2Cipher;
import cn.com.infosec.asn1.gm.SM2EnvelopedKey;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.crypto.InvalidCipherTextException;
import cn.com.infosec.crypto.engines.SM2Engine;
import cn.com.infosec.crypto.params.ECDomainParameters;
import cn.com.infosec.crypto.params.ECPublicKeyParameters;
import cn.com.infosec.crypto.util.SubjectPublicKeyInfoFactory;
import cn.com.infosec.jcajce.provider.asymmetric.util.ECUtil;
import cn.com.infosec.math.ec.ECPoint;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;

public class SM2EnvelopedKeyBuilder {
    private static final int DIGEST_LEN = 32;
    private static final int CURVE_LEN = 32;

    public static SM2EnvelopedKey generateSM2EnvelopedKey(byte[] cipherData, PublicKey publicKey, byte[] priKeyCipher) throws InvalidKeyException, IOException, InvalidCipherTextException {
        if (publicKey instanceof ECPublicKey) {
            return SM2EnvelopedKeyBuilder.generateSM2EnvelopedKey(SM2Engine.Mode.C1C3C2, GMObjectIdentifiers.sms4_ecb, cipherData, 0, cipherData.length, publicKey, priKeyCipher);
        }
        throw new InvalidKeyException("not a EC PublicKey");
    }

    public static SM2EnvelopedKey generateSM2EnvelopedKey(SM2Engine.Mode mode, ASN1ObjectIdentifier oid, byte[] cipherData, int inOff, int inLen, PublicKey publicKey, byte[] priKeyCipher) throws InvalidKeyException, InvalidCipherTextException, IOException {
        ECPublicKeyParameters param = (ECPublicKeyParameters)ECUtil.generatePublicKeyParameter(publicKey);
        ECDomainParameters ecParams = param.getParameters();
        SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(param);
        byte[] c1 = new byte[65];
        System.arraycopy(cipherData, inOff, c1, 0, c1.length);
        ECPoint c1P = ecParams.getCurve().decodePoint(c1);
        ECPoint s = c1P.multiply(ecParams.getH());
        if (s.isInfinity()) {
            throw new InvalidCipherTextException("[h]C1 at infinity");
        }
        byte[] c3 = new byte[32];
        byte[] c2 = new byte[inLen - c1.length - 32];
        if (SM2Engine.Mode.C1C3C2.equals((Object)mode)) {
            System.arraycopy(cipherData, inOff + c1.length, c3, 0, 32);
            System.arraycopy(cipherData, inOff + c1.length + 32, c2, 0, c2.length);
            SM2Cipher sm2Cipher = new SM2Cipher(s.getAffineXCoord().toBigInteger(), s.getAffineYCoord().toBigInteger(), c3, c2);
            return new SM2EnvelopedKey(new AlgorithmIdentifier(oid), sm2Cipher, publicKeyInfo.getPublicKeyData().getBytes(), priKeyCipher);
        }
        System.arraycopy(cipherData, inOff + c1.length, c2, 0, c2.length);
        System.arraycopy(cipherData, cipherData.length - 32, c3, 0, 32);
        SM2Cipher sm2Cipher = new SM2Cipher(s.getAffineXCoord().toBigInteger(), s.getAffineYCoord().toBigInteger(), c3, c2);
        return new SM2EnvelopedKey(new AlgorithmIdentifier(oid), sm2Cipher, publicKeyInfo.getPublicKeyData().getBytes(), priKeyCipher);
    }
}

