/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.gm;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Integer;
import cn.com.infosec.asn1.ASN1Object;
import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.ASN1Primitive;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.DERBitString;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.util.BigIntegers;
import java.math.BigInteger;
import java.util.Enumeration;

public class SM9PrivateKey
extends ASN1Object {
    private ASN1Sequence seq;

    private SM9PrivateKey(ASN1Sequence seq) {
        this.seq = seq;
    }

    public static SM9PrivateKey getInstance(Object obj) {
        if (obj instanceof SM9PrivateKey) {
            return (SM9PrivateKey)obj;
        }
        if (obj != null) {
            return new SM9PrivateKey(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public SM9PrivateKey(BigInteger key) {
        this(key.bitLength(), key);
    }

    public SM9PrivateKey(int orderBitLength, BigInteger key) {
        byte[] bytes = BigIntegers.asUnsignedByteArray((orderBitLength + 7) / 8, key);
        ASN1EncodableVector v = new ASN1EncodableVector(2);
        v.add(new ASN1Integer(1L));
        v.add(new DEROctetString(bytes));
        this.seq = new DERSequence(v);
    }

    public SM9PrivateKey(byte[] key) {
        this(null, null, key, null);
    }

    public SM9PrivateKey(byte[] zzn12sign, byte[] zzn12enc, long handler, byte[] key) {
        this(zzn12sign, zzn12enc, key, null);
    }

    public SM9PrivateKey(byte[] zzn12sign, byte[] zzn12enc, byte[] key, DERBitString publicKey) {
        ASN1EncodableVector v = new ASN1EncodableVector(4);
        v.add(new ASN1Integer(1L));
        v.add(new DEROctetString(zzn12sign));
        if (zzn12enc != null) {
            v.add(new DEROctetString(zzn12enc));
        }
        v.add(new DEROctetString(key));
        if (publicKey != null) {
            v.add(new DERTaggedObject(true, 1, publicKey));
        }
        this.seq = new DERSequence(v);
    }

    public BigInteger getKey() {
        ASN1OctetString octs = (ASN1OctetString)this.seq.getObjectAt(1);
        return new BigInteger(1, octs.getOctets());
    }

    public DERBitString getPublicKey() {
        return (DERBitString)this.getObjectInTag(1);
    }

    public ASN1Primitive getParameters() {
        return this.getObjectInTag(0);
    }

    private ASN1Primitive getObjectInTag(int tagNo) {
        Enumeration e = this.seq.getObjects();
        while (e.hasMoreElements()) {
            ASN1TaggedObject tag;
            ASN1Encodable obj = (ASN1Encodable)e.nextElement();
            if (!(obj instanceof ASN1TaggedObject) || (tag = (ASN1TaggedObject)obj).getTagNo() != tagNo) continue;
            return tag.getObject().toASN1Primitive();
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.seq;
    }
}

