/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.cert.dane;

import cn.com.infosec.cert.X509CertificateHolder;
import cn.com.infosec.cert.dane.DANEEntry;
import cn.com.infosec.cert.dane.DANEEntryFetcherFactory;
import cn.com.infosec.cert.dane.DANEEntrySelector;
import cn.com.infosec.cert.dane.DANEEntrySelectorFactory;
import cn.com.infosec.cert.dane.DANEException;
import cn.com.infosec.operator.DigestCalculator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DANECertificateFetcher {
    private final DANEEntryFetcherFactory fetcherFactory;
    private final DANEEntrySelectorFactory selectorFactory;

    public DANECertificateFetcher(DANEEntryFetcherFactory fetcherFactory, DigestCalculator digestCalculator) {
        this.fetcherFactory = fetcherFactory;
        this.selectorFactory = new DANEEntrySelectorFactory(digestCalculator);
    }

    public List fetch(String emailAddress) throws DANEException {
        DANEEntrySelector daneSelector = this.selectorFactory.createSelector(emailAddress);
        List matches = this.fetcherFactory.build(daneSelector.getDomainName()).getEntries();
        ArrayList<X509CertificateHolder> certs = new ArrayList<X509CertificateHolder>(matches.size());
        for (DANEEntry next : matches) {
            if (!daneSelector.match(next)) continue;
            certs.add(next.getCertificate());
        }
        return Collections.unmodifiableList(certs);
    }
}

