/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.cert.ocsp;

import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ocsp.ResponseData;
import cn.com.infosec.asn1.ocsp.SingleResponse;
import cn.com.infosec.asn1.x509.Extensions;
import cn.com.infosec.cert.ocsp.OCSPUtils;
import cn.com.infosec.cert.ocsp.RespID;
import cn.com.infosec.cert.ocsp.SingleResp;
import java.util.Date;

public class RespData {
    private ResponseData data;

    public RespData(ResponseData data) {
        this.data = data;
    }

    public int getVersion() {
        return this.data.getVersion().intValueExact() + 1;
    }

    public RespID getResponderId() {
        return new RespID(this.data.getResponderID());
    }

    public Date getProducedAt() {
        return OCSPUtils.extractDate(this.data.getProducedAt());
    }

    public SingleResp[] getResponses() {
        ASN1Sequence s = this.data.getResponses();
        SingleResp[] rs = new SingleResp[s.size()];
        for (int i = 0; i != rs.length; ++i) {
            rs[i] = new SingleResp(SingleResponse.getInstance(s.getObjectAt(i)));
        }
        return rs;
    }

    public Extensions getResponseExtensions() {
        return this.data.getResponseExtensions();
    }
}

