/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.cms;

import cn.com.infosec.asn1.cms.KEKIdentifier;
import cn.com.infosec.asn1.cms.KEKRecipientInfo;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.cms.AuthAttributesProvider;
import cn.com.infosec.cms.CMSException;
import cn.com.infosec.cms.CMSSecureReadable;
import cn.com.infosec.cms.KEKRecipient;
import cn.com.infosec.cms.KEKRecipientId;
import cn.com.infosec.cms.Recipient;
import cn.com.infosec.cms.RecipientInformation;
import cn.com.infosec.cms.RecipientOperator;
import java.io.IOException;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        KEKIdentifier kekId = info.getKekid();
        this.rid = new KEKRecipientId(kekId.getKeyIdentifier().getOctets());
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

