/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.cms;

import cn.com.infosec.asn1.ASN1ObjectIdentifier;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.cms.IssuerAndSerialNumber;
import cn.com.infosec.asn1.cms.KeyTransRecipientInfo;
import cn.com.infosec.asn1.cms.RecipientIdentifier;
import cn.com.infosec.asn1.cms.RecipientInfo;
import cn.com.infosec.asn1.gm.GMObjectIdentifiers;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x9.X9ObjectIdentifiers;
import cn.com.infosec.cms.CMSException;
import cn.com.infosec.cms.RecipientInfoGenerator;
import cn.com.infosec.operator.AsymmetricKeyWrapper;
import cn.com.infosec.operator.GenericKey;
import cn.com.infosec.operator.OperatorException;

public abstract class KeyTransRecipientInfoGenerator
implements RecipientInfoGenerator {
    protected final AsymmetricKeyWrapper wrapper;
    private IssuerAndSerialNumber issuerAndSerial;
    private byte[] subjectKeyIdentifier;

    protected KeyTransRecipientInfoGenerator(IssuerAndSerialNumber issuerAndSerial, AsymmetricKeyWrapper wrapper) {
        this.issuerAndSerial = issuerAndSerial;
        this.wrapper = wrapper;
    }

    protected KeyTransRecipientInfoGenerator(byte[] subjectKeyIdentifier, AsymmetricKeyWrapper wrapper) {
        this.subjectKeyIdentifier = subjectKeyIdentifier;
        this.wrapper = wrapper;
    }

    @Override
    public final RecipientInfo generate(GenericKey contentEncryptionKey) throws CMSException {
        byte[] encryptedKeyBytes;
        try {
            encryptedKeyBytes = this.wrapper.generateWrappedKey(contentEncryptionKey);
        }
        catch (OperatorException e) {
            throw new CMSException("exception wrapping content key: " + e.getMessage(), e);
        }
        RecipientIdentifier recipId = this.issuerAndSerial != null ? new RecipientIdentifier(this.issuerAndSerial) : new RecipientIdentifier(new DEROctetString(this.subjectKeyIdentifier));
        AlgorithmIdentifier keyEncryptionAlgorithm = null;
        if (this.wrapper.getAlgorithmIdentifier().getAlgorithm().getId().equalsIgnoreCase(X9ObjectIdentifiers.id_ecPublicKey.getId())) {
            if (this.wrapper.getAlgorithmIdentifier().getParameters() != null && this.wrapper.getAlgorithmIdentifier().getParameters() instanceof ASN1ObjectIdentifier && ((ASN1ObjectIdentifier)this.wrapper.getAlgorithmIdentifier().getParameters()).getId().equalsIgnoreCase(GMObjectIdentifiers.sm2p256v1.getId())) {
                keyEncryptionAlgorithm = new AlgorithmIdentifier(GMObjectIdentifiers.sm2encrypt);
            }
        } else {
            keyEncryptionAlgorithm = this.wrapper.getAlgorithmIdentifier();
        }
        return new RecipientInfo(new KeyTransRecipientInfo(recipId, keyEncryptionAlgorithm, new DEROctetString(encryptedKeyBytes)));
    }
}

