/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.cms;

import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.cms.IssuerAndSerialNumber;
import cn.com.infosec.asn1.cms.KeyTransRecipientInfo;
import cn.com.infosec.asn1.cms.RecipientIdentifier;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.cms.AuthAttributesProvider;
import cn.com.infosec.cms.CMSException;
import cn.com.infosec.cms.CMSSecureReadable;
import cn.com.infosec.cms.KeyTransRecipient;
import cn.com.infosec.cms.KeyTransRecipientId;
import cn.com.infosec.cms.Recipient;
import cn.com.infosec.cms.RecipientInformation;
import cn.com.infosec.cms.RecipientOperator;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        RecipientIdentifier r = info.getRecipientIdentifier();
        if (r.isTagged()) {
            ASN1OctetString octs = ASN1OctetString.getInstance(r.getId());
            this.rid = new KeyTransRecipientId(octs.getOctets());
        } else {
            IssuerAndSerialNumber iAnds = IssuerAndSerialNumber.getInstance(r.getId());
            this.rid = new KeyTransRecipientId(iAnds.getName(), iAnds.getSerialNumber().getValue());
        }
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

