/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.cms.jcajce;

import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.cms.jcajce.CMSUtils;
import cn.com.infosec.cms.jcajce.JcaJceExtHelper;
import cn.com.infosec.jcajce.util.NamedJcaJceHelper;
import cn.com.infosec.operator.SymmetricKeyUnwrapper;
import cn.com.infosec.operator.jcajce.JceAsymmetricKeyUnwrapper;
import cn.com.infosec.operator.jcajce.JceKTSKeyUnwrapper;
import cn.com.infosec.operator.jcajce.JceSymmetricKeyUnwrapper;
import java.security.PrivateKey;
import javax.crypto.SecretKey;

class NamedJcaJceExtHelper
extends NamedJcaJceHelper
implements JcaJceExtHelper {
    public NamedJcaJceExtHelper(String providerName) {
        super(providerName);
    }

    @Override
    public JceAsymmetricKeyUnwrapper createAsymmetricUnwrapper(AlgorithmIdentifier keyEncryptionAlgorithm, PrivateKey keyEncryptionKey) {
        keyEncryptionKey = CMSUtils.cleanPrivateKey(keyEncryptionKey);
        return new JceAsymmetricKeyUnwrapper(keyEncryptionAlgorithm, keyEncryptionKey).setProvider(this.providerName);
    }

    @Override
    public JceKTSKeyUnwrapper createAsymmetricUnwrapper(AlgorithmIdentifier keyEncryptionAlgorithm, PrivateKey keyEncryptionKey, byte[] partyUInfo, byte[] partyVInfo) {
        keyEncryptionKey = CMSUtils.cleanPrivateKey(keyEncryptionKey);
        return new JceKTSKeyUnwrapper(keyEncryptionAlgorithm, keyEncryptionKey, partyUInfo, partyVInfo).setProvider(this.providerName);
    }

    @Override
    public SymmetricKeyUnwrapper createSymmetricUnwrapper(AlgorithmIdentifier keyEncryptionAlgorithm, SecretKey keyEncryptionKey) {
        return new JceSymmetricKeyUnwrapper(keyEncryptionAlgorithm, keyEncryptionKey).setProvider(this.providerName);
    }
}

