/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.agreement;

import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.RawAgreement;
import cn.com.infosec.crypto.params.XDHUPrivateParameters;
import cn.com.infosec.crypto.params.XDHUPublicParameters;

public class XDHUnifiedAgreement
implements RawAgreement {
    private final RawAgreement xAgreement;
    private XDHUPrivateParameters privParams;

    public XDHUnifiedAgreement(RawAgreement xAgreement) {
        this.xAgreement = xAgreement;
    }

    @Override
    public void init(CipherParameters key) {
        this.privParams = (XDHUPrivateParameters)key;
    }

    @Override
    public int getAgreementSize() {
        return this.xAgreement.getAgreementSize() * 2;
    }

    @Override
    public void calculateAgreement(CipherParameters publicKey, byte[] buf, int off) {
        XDHUPublicParameters pubParams = (XDHUPublicParameters)publicKey;
        this.xAgreement.init(this.privParams.getEphemeralPrivateKey());
        this.xAgreement.calculateAgreement(pubParams.getEphemeralPublicKey(), buf, off);
        this.xAgreement.init(this.privParams.getStaticPrivateKey());
        this.xAgreement.calculateAgreement(pubParams.getStaticPublicKey(), buf, off + this.xAgreement.getAgreementSize());
    }
}

