/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.ec;

import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.ec.ECDecryptor;
import cn.com.infosec.crypto.ec.ECPair;
import cn.com.infosec.crypto.params.ECPrivateKeyParameters;
import cn.com.infosec.math.ec.ECAlgorithms;
import cn.com.infosec.math.ec.ECCurve;
import cn.com.infosec.math.ec.ECPoint;

public class ECElGamalDecryptor
implements ECDecryptor {
    private ECPrivateKeyParameters key;

    @Override
    public void init(CipherParameters param) {
        if (!(param instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("ECPrivateKeyParameters are required for decryption.");
        }
        this.key = (ECPrivateKeyParameters)param;
    }

    @Override
    public ECPoint decrypt(ECPair pair) {
        if (this.key == null) {
            throw new IllegalStateException("ECElGamalDecryptor not initialised");
        }
        ECCurve curve = this.key.getParameters().getCurve();
        ECPoint tmp = ECAlgorithms.cleanPoint(curve, pair.getX()).multiply(this.key.getD());
        return ECAlgorithms.cleanPoint(curve, pair.getY()).subtract(tmp).normalize();
    }
}

