/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.encodings;

import cn.com.infosec.crypto.AsymmetricBlockCipher;
import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.CryptoServicesRegistrar;
import cn.com.infosec.crypto.InvalidCipherTextException;
import cn.com.infosec.crypto.RuntimeCryptoException;
import cn.com.infosec.crypto.params.ParametersWithRandom;
import cn.com.infosec.crypto.params.RSAKeyParameters;
import cn.com.infosec.crypto.params.RSAPrivateCrtKeyParameters;
import cn.com.infosec.device.IPPRsaFactory;
import cn.com.infosec.device.ipp.rsa.HashAlgType;
import cn.com.infosec.device.ipp.rsa.IPPRsaKeyPair;
import cn.com.infosec.device.sds.IPPRsaDevice;
import cn.com.infosec.device.util.PrintUtil;
import cn.com.infosec.util.BigIntegerUtil;
import cn.com.infosec.util.Debug;
import java.security.SecureRandom;

public class IPPOAEPEncoding
implements AsymmetricBlockCipher {
    private final HashAlgType digest;
    private RSAKeyParameters key;
    private SecureRandom random;
    private boolean forEncryption;

    public IPPOAEPEncoding(HashAlgType digest) {
        this.digest = digest;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (RSAKeyParameters)rParam.getParameters();
            this.random = this.key instanceof RSAPrivateCrtKeyParameters ? rParam.getRandom() : null;
        } else {
            this.key = (RSAKeyParameters)param;
            this.random = this.key instanceof RSAPrivateCrtKeyParameters ? CryptoServicesRegistrar.getSecureRandom() : null;
        }
        this.forEncryption = forEncryption;
    }

    @Override
    public int getInputBlockSize() {
        int bitSize = this.key.getModulus().bitLength();
        if (this.forEncryption) {
            return (bitSize + 7) / 8 - 1;
        }
        return (bitSize + 7) / 8;
    }

    @Override
    public int getOutputBlockSize() {
        int bitSize = this.key.getModulus().bitLength();
        if (this.forEncryption) {
            return (bitSize + 7) / 8;
        }
        return (bitSize + 7) / 8 - 1;
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        byte[] signature;
        if (this.key == null) {
            throw new IllegalStateException("RSA OAEP cipher engine not initialised");
        }
        IPPRsaDevice device = null;
        try {
            device = IPPRsaFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        if (this.forEncryption) {
            int keyBytes = (this.key.getModulus().bitLength() + 7) / 8;
            IPPRsaKeyPair keyPair = new IPPRsaKeyPair(this.key.getExponent().intValue(), BigIntegerUtil.asUnsignedNByteArray(this.key.getModulus(), keyBytes), null, null, null, null, null, null);
            try {
                byte[] pin = new byte[]{};
                return device.rsaEncryptOAEP(in, inLen, pin, pin.length, this.digest, keyPair);
            }
            catch (Exception e) {
                throw new RuntimeCryptoException(e.getMessage());
            }
        }
        RSAPrivateCrtKeyParameters keyParam = (RSAPrivateCrtKeyParameters)this.key;
        int keyBytes = (keyParam.getP().bitLength() + 7) / 8;
        IPPRsaKeyPair keyPair = new IPPRsaKeyPair(0, null, null, BigIntegerUtil.asUnsignedNByteArray(keyParam.getP(), keyBytes), BigIntegerUtil.asUnsignedNByteArray(keyParam.getQ(), keyBytes), BigIntegerUtil.asUnsignedNByteArray(keyParam.getDP(), keyBytes), BigIntegerUtil.asUnsignedNByteArray(keyParam.getDQ(), keyBytes), BigIntegerUtil.asUnsignedNByteArray(keyParam.getQInv(), keyBytes));
        try {
            byte[] pin = new byte[]{};
            signature = device.rsaDecryptOAEP(in, inLen, pin, pin.length, this.digest, keyPair);
        }
        catch (Exception e) {
            Debug.println(Debug.ERROR, "RSA OAEP cipher error");
            System.err.println("data input");
            System.err.println(PrintUtil.toHexString(in));
            throw new RuntimeCryptoException(e.getMessage());
        }
        return signature;
    }
}

