/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.engines;

import cn.com.infosec.crypto.AsymmetricBlockCipher;
import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.DataLengthException;
import cn.com.infosec.crypto.InvalidCipherTextException;
import cn.com.infosec.crypto.RuntimeCryptoException;
import cn.com.infosec.crypto.params.ParametersWithRandom;
import cn.com.infosec.crypto.params.RSAKeyParameters;
import cn.com.infosec.crypto.params.RSAPrivateCrtKeyParameters;
import cn.com.infosec.device.IPPRsaFactory;
import cn.com.infosec.device.ipp.rsa.IPPRsaKeyPair;
import cn.com.infosec.device.sds.IPPRsaDevice;
import cn.com.infosec.util.Arrays;
import cn.com.infosec.util.BigIntegerUtil;
import java.math.BigInteger;

public class IPPRSACoreEngine
implements AsymmetricBlockCipher {
    private RSAKeyParameters key;
    private boolean forEncryption;
    private IPPRsaDevice device;

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (RSAKeyParameters)rParam.getParameters();
        } else {
            this.key = (RSAKeyParameters)param;
        }
        this.forEncryption = forEncryption;
        try {
            this.device = IPPRsaFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
    }

    @Override
    public int getInputBlockSize() {
        int bitSize = this.key.getModulus().bitLength();
        if (this.forEncryption) {
            return (bitSize + 7) / 8 - 1;
        }
        return (bitSize + 7) / 8;
    }

    @Override
    public int getOutputBlockSize() {
        int bitSize = this.key.getModulus().bitLength();
        if (this.forEncryption) {
            return (bitSize + 7) / 8;
        }
        return (bitSize + 7) / 8 - 1;
    }

    public BigInteger convertInput(byte[] in, int inOff, int inLen) {
        byte[] block;
        if (inLen > this.getInputBlockSize() + 1) {
            throw new DataLengthException("input too large for RSA cipher.");
        }
        if (inLen == this.getInputBlockSize() + 1 && !this.forEncryption) {
            throw new DataLengthException("input too large for RSA cipher.");
        }
        if (inOff != 0 || inLen != in.length) {
            block = new byte[inLen];
            System.arraycopy(in, inOff, block, 0, inLen);
        } else {
            block = in;
        }
        BigInteger res = new BigInteger(1, block);
        if (res.compareTo(this.key.getModulus()) >= 0) {
            throw new DataLengthException("input too large for RSA cipher.");
        }
        return res;
    }

    public byte[] convertOutput(byte[] output) {
        byte[] rv;
        if (this.forEncryption) {
            if (output[0] == 0 && output.length > this.getOutputBlockSize()) {
                byte[] tmp = new byte[output.length - 1];
                System.arraycopy(output, 1, tmp, 0, tmp.length);
                return tmp;
            }
            if (output.length < this.getOutputBlockSize()) {
                byte[] tmp = new byte[this.getOutputBlockSize()];
                System.arraycopy(output, 0, tmp, tmp.length - output.length, output.length);
                return tmp;
            }
            return output;
        }
        if (output[0] == 0) {
            rv = new byte[output.length - 1];
            System.arraycopy(output, 1, rv, 0, rv.length);
        } else {
            rv = new byte[output.length];
            System.arraycopy(output, 0, rv, 0, rv.length);
        }
        Arrays.fill(output, (byte)0);
        return rv;
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int len) throws InvalidCipherTextException {
        byte[] result;
        if (this.key instanceof RSAPrivateCrtKeyParameters) {
            RSAPrivateCrtKeyParameters keyParam = (RSAPrivateCrtKeyParameters)this.key;
            int keyBytes = (keyParam.getP().bitLength() + 7) / 8;
            IPPRsaKeyPair keyPair = new IPPRsaKeyPair(0, null, null, BigIntegerUtil.asUnsignedNByteArray(keyParam.getP(), keyBytes), BigIntegerUtil.asUnsignedNByteArray(keyParam.getQ(), keyBytes), BigIntegerUtil.asUnsignedNByteArray(keyParam.getDP(), keyBytes), BigIntegerUtil.asUnsignedNByteArray(keyParam.getDQ(), keyBytes), BigIntegerUtil.asUnsignedNByteArray(keyParam.getQInv(), keyBytes));
            try {
                result = this.device.rsaDecrypt(in, len, keyPair);
            }
            catch (Exception e) {
                throw new RuntimeCryptoException(e.getMessage());
            }
        }
        int keyBytes = (this.key.getModulus().bitLength() + 7) / 8;
        IPPRsaKeyPair keyPair = new IPPRsaKeyPair(this.key.getExponent().intValue(), BigIntegerUtil.asUnsignedNByteArray(this.key.getModulus(), keyBytes), null, null, null, null, null, null);
        try {
            result = this.device.rsaEncrypt(in, len, keyPair);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        return this.convertOutput(result);
    }
}

