/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.generators;

import cn.com.infosec.crypto.AsymmetricCipherKeyPair;
import cn.com.infosec.crypto.AsymmetricCipherKeyPairGenerator;
import cn.com.infosec.crypto.KeyGenerationParameters;
import cn.com.infosec.crypto.params.DSAKeyGenerationParameters;
import cn.com.infosec.crypto.params.DSAParameters;
import cn.com.infosec.crypto.params.DSAPrivateKeyParameters;
import cn.com.infosec.crypto.params.DSAPublicKeyParameters;
import cn.com.infosec.math.ec.WNafUtil;
import cn.com.infosec.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DSAKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (DSAKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DSAParameters dsaParams = this.param.getParameters();
        BigInteger x = DSAKeyPairGenerator.generatePrivateKey(dsaParams.getQ(), this.param.getRandom());
        BigInteger y = DSAKeyPairGenerator.calculatePublicKey(dsaParams.getP(), dsaParams.getG(), x);
        return new AsymmetricCipherKeyPair(new DSAPublicKeyParameters(y, dsaParams), new DSAPrivateKeyParameters(x, dsaParams));
    }

    private static BigInteger generatePrivateKey(BigInteger q, SecureRandom random) {
        BigInteger x;
        int minWeight = q.bitLength() >>> 2;
        while (WNafUtil.getNafWeight(x = BigIntegers.createRandomInRange(ONE, q.subtract(ONE), random)) < minWeight) {
        }
        return x;
    }

    private static BigInteger calculatePublicKey(BigInteger p, BigInteger g, BigInteger x) {
        return g.modPow(x, p);
    }
}

