/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.generators;

import cn.com.infosec.crypto.AsymmetricCipherKeyPair;
import cn.com.infosec.crypto.AsymmetricCipherKeyPairGenerator;
import cn.com.infosec.crypto.KeyGenerationParameters;
import cn.com.infosec.crypto.RuntimeCryptoException;
import cn.com.infosec.crypto.params.RSAKeyGenerationParameters;
import cn.com.infosec.crypto.params.RSAKeyParameters;
import cn.com.infosec.crypto.params.RSAPrivateCrtKeyParameters;
import cn.com.infosec.device.IPPRsaFactory;
import cn.com.infosec.device.ipp.rsa.IPPRsaKeyPair;
import cn.com.infosec.device.sds.IPPRsaDevice;
import cn.com.infosec.util.BigIntegerUtil;
import java.math.BigInteger;

public class IPPRSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private RSAKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (RSAKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        IPPRsaDevice device = null;
        try {
            device = IPPRsaFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        IPPRsaKeyPair keyPair = null;
        try {
            keyPair = device.generateRSAKeyPair(this.param.getStrength(), this.param.getPublicExponent().intValue());
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        BigInteger pubModul = BigIntegerUtil.toPositiveInteger(keyPair.getN());
        BigInteger pubExponent = BigInteger.valueOf(keyPair.getE());
        return new AsymmetricCipherKeyPair(new RSAKeyParameters(false, pubModul, pubExponent), new RSAPrivateCrtKeyParameters(pubModul, pubExponent, BigIntegerUtil.toPositiveInteger(keyPair.getD()), BigIntegerUtil.toPositiveInteger(keyPair.getP()), BigIntegerUtil.toPositiveInteger(keyPair.getQ()), BigIntegerUtil.toPositiveInteger(keyPair.getDp()), BigIntegerUtil.toPositiveInteger(keyPair.getDq()), BigIntegerUtil.toPositiveInteger(keyPair.getQinv())));
    }
}

