/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.generators;

import cn.com.infosec.crypto.AsymmetricCipherKeyPair;
import cn.com.infosec.crypto.AsymmetricCipherKeyPairGenerator;
import cn.com.infosec.crypto.KeyGenerationParameters;
import cn.com.infosec.crypto.RuntimeCryptoException;
import cn.com.infosec.crypto.params.ECKeyGenerationParameters;
import cn.com.infosec.crypto.params.ECPrivateKeyParameters;
import cn.com.infosec.crypto.params.ECPublicKeyParameters;
import cn.com.infosec.device.SDSFactory;
import cn.com.infosec.device.bean.SM2refKeyPair;
import cn.com.infosec.device.bean.SM2refPrivateKey;
import cn.com.infosec.device.bean.SM2refPublicKey;
import cn.com.infosec.device.crypto.ISDSCrypto;
import cn.com.infosec.math.ec.ECPoint;
import cn.com.infosec.util.BigIntegerUtil;
import java.math.BigInteger;

public class SM2KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ECKeyGenerationParameters param;

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        int strength = this.param.getStrength();
        ISDSCrypto device = null;
        try {
            device = SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        SM2refKeyPair keyPair = null;
        try {
            keyPair = device.generateSM2KeyPair(strength);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        BigInteger d = null;
        ECPoint Q = null;
        SM2refPrivateKey privateKey = keyPair.getPrivateKey();
        d = BigIntegerUtil.toPositiveInteger(privateKey.getD());
        SM2refPublicKey publicKey = keyPair.getPublicKey();
        Q = this.param.getDomainParameters().getCurve().decodePoint(publicKey.getQ());
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(Q, this.param.getDomainParameters()), new ECPrivateKeyParameters(d, this.param.getDomainParameters()));
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (ECKeyGenerationParameters)param;
    }
}

