/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.generators;

import cn.com.infosec.crypto.AsymmetricCipherKeyPair;
import cn.com.infosec.crypto.AsymmetricCipherKeyPairGenerator;
import cn.com.infosec.crypto.KeyGenerationParameters;
import cn.com.infosec.crypto.RuntimeCryptoException;
import cn.com.infosec.crypto.params.SM9PrivateKeyParameters;
import cn.com.infosec.crypto.params.SM9UserKeyGenerationParameters;
import cn.com.infosec.crypto.params.SM9UserPublicKeyParameters;
import cn.com.infosec.device.IBEFactory;
import cn.com.infosec.device.ibe.SM9UserKeyPair;
import cn.com.infosec.device.sds.IBEDevice;
import cn.com.infosec.jce.spec.SM9ParameterSpec;
import cn.com.infosec.util.ByteArrayUtil;

public class SM9UserKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SM9UserKeyGenerationParameters param;

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        IBEDevice device = null;
        try {
            device = IBEFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        SM9UserKeyPair keyPair = null;
        SM9ParameterSpec para = this.param.getAlgorithmParameters();
        byte[] zzn12sign = para.getMsk().getZzn12Sign();
        int[] msk = ByteArrayUtil.byteArrayTointArray(para.getMsk().getD());
        int[] mpk = ByteArrayUtil.byteArrayTointArray(para.getMpk().getQ());
        try {
            keyPair = device.generateUserKeyPair(this.param.getStrength(), mpk, msk, para.getUid());
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        byte[] privateKey = keyPair.getPrivateKey();
        byte[] publicKey = keyPair.getPublicKey();
        return new AsymmetricCipherKeyPair(new SM9UserPublicKeyParameters(zzn12sign, para.getMsk().getZzn12Enc(), keyPair.getLen(), keyPair.getUid(), publicKey), new SM9PrivateKeyParameters(zzn12sign, null, keyPair.getLen(), keyPair.getUid(), privateKey));
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (SM9UserKeyGenerationParameters)param;
    }
}

