/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.generators;

import cn.com.infosec.crypto.AsymmetricCipherKeyPair;
import cn.com.infosec.crypto.AsymmetricCipherKeyPairGenerator;
import cn.com.infosec.crypto.KeyGenerationParameters;
import cn.com.infosec.crypto.params.X25519PrivateKeyParameters;
import cn.com.infosec.crypto.params.X25519PublicKeyParameters;
import java.security.SecureRandom;

public class X25519KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters parameters) {
        this.random = parameters.getRandom();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        X25519PrivateKeyParameters privateKey = new X25519PrivateKeyParameters(this.random);
        X25519PublicKeyParameters publicKey = privateKey.generatePublicKey();
        return new AsymmetricCipherKeyPair(publicKey, privateKey);
    }
}

