/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.params;

import cn.com.infosec.crypto.params.AsymmetricKeyParameter;
import cn.com.infosec.crypto.params.Ed448PublicKeyParameters;
import cn.com.infosec.math.ec.rfc8032.Ed448;
import cn.com.infosec.util.Arrays;
import cn.com.infosec.util.io.Streams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;

public final class Ed448PrivateKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 57;
    public static final int SIGNATURE_SIZE = 114;
    private final byte[] data = new byte[57];

    public Ed448PrivateKeyParameters(SecureRandom random) {
        super(true);
        Ed448.generatePrivateKey(random, this.data);
    }

    public Ed448PrivateKeyParameters(byte[] buf, int off) {
        super(true);
        System.arraycopy(buf, off, this.data, 0, 57);
    }

    public Ed448PrivateKeyParameters(InputStream input) throws IOException {
        super(true);
        if (57 != Streams.readFully(input, this.data)) {
            throw new EOFException("EOF encountered in middle of Ed448 private key");
        }
    }

    public void encode(byte[] buf, int off) {
        System.arraycopy(this.data, 0, buf, off, 57);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.data);
    }

    public Ed448PublicKeyParameters generatePublicKey() {
        byte[] publicKey = new byte[57];
        Ed448.generatePublicKey(this.data, 0, publicKey, 0);
        return new Ed448PublicKeyParameters(publicKey, 0);
    }

    public void sign(int algorithm, Ed448PublicKeyParameters publicKey, byte[] ctx, byte[] msg, int msgOff, int msgLen, byte[] sig, int sigOff) {
        byte[] pk = new byte[57];
        if (null == publicKey) {
            Ed448.generatePublicKey(this.data, 0, pk, 0);
        } else {
            publicKey.encode(pk, 0);
        }
        switch (algorithm) {
            case 0: {
                Ed448.sign(this.data, 0, pk, 0, ctx, msg, msgOff, msgLen, sig, sigOff);
                break;
            }
            case 1: {
                if (64 != msgLen) {
                    throw new IllegalArgumentException("msgLen");
                }
                Ed448.signPrehash(this.data, 0, pk, 0, ctx, msg, msgOff, sig, sigOff);
                break;
            }
            default: {
                throw new IllegalArgumentException("algorithm");
            }
        }
    }
}

