/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.util;

import cn.com.infosec.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class SSHBuilder {
    private final ByteArrayOutputStream bos = new ByteArrayOutputStream();

    SSHBuilder() {
    }

    public void u32(long value) {
        this.bos.write((int)(value >>> 24 & 0xFFL));
        this.bos.write((int)(value >>> 16 & 0xFFL));
        this.bos.write((int)(value >>> 8 & 0xFFL));
        this.bos.write((int)(value & 0xFFL));
    }

    public void rawArray(byte[] value) {
        this.u32(value.length);
        try {
            this.bos.write(value);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void write(byte[] value) {
        try {
            this.bos.write(value);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void writeString(String str) {
        this.rawArray(Strings.toByteArray(str));
    }

    public byte[] getBytes() {
        return this.bos.toByteArray();
    }
}

