/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.device.bean;

import cn.com.infosec.device.crypto.CryptoException;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;

public class ECCrefPublicKey {
    private int bits;
    private byte[] x;
    private byte[] y;
    private byte[] q;

    public int getBits() {
        return this.bits;
    }

    public byte[] getX() {
        return this.x;
    }

    public byte[] getY() {
        return this.y;
    }

    public byte[] getQ() {
        return this.q;
    }

    public ECCrefPublicKey() {
    }

    public ECCrefPublicKey(int size) {
        this.bits = size;
        this.q = new byte[(this.bits >> 2) + 1];
    }

    public ECCrefPublicKey(byte[] x, byte[] y) {
        this.bits = x.length << 3;
        this.q = new byte[(this.bits >> 2) + 1];
        this.q[0] = 4;
        this.x = new byte[this.bits >> 3];
        this.y = new byte[this.bits >> 3];
        System.arraycopy(x, 0, this.x, this.x.length - x.length, x.length);
        System.arraycopy(y, 0, this.y, this.y.length - y.length, y.length);
        System.arraycopy(x, 0, this.q, 1, this.x.length);
        System.arraycopy(y, 0, this.q, 33, this.y.length);
    }

    public ECCrefPublicKey(int size, byte[] x, byte[] y) {
        this.bits = size;
        this.q = new byte[(this.bits >> 2) + 1];
        this.q[0] = 4;
        this.x = new byte[this.bits >> 3];
        this.y = new byte[this.bits >> 3];
        System.arraycopy(x, 0, this.q, 1, this.x.length);
        System.arraycopy(y, 0, this.q, this.x.length + 1, this.y.length);
    }

    public void decode(byte[] publicKey) throws CryptoException {
        int size = this.bits / 8;
        int pos = 1;
        System.arraycopy(publicKey, pos, this.x, 0, size);
        System.arraycopy(publicKey, pos += this.x.length, this.y, 0, size);
        if ((pos += this.y.length) != publicKey.length) {
            throw new CryptoException("inputData length != ECCPublicKey length");
        }
        System.arraycopy(publicKey, 0, this.q, 0, publicKey.length);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append(nl);
        buf.append("bits: ").append(this.bits).append(nl);
        buf.append("   X: ").append(new BigInteger(1, this.x).toString(16)).append(nl);
        buf.append("   Y: ").append(new BigInteger(1, this.y).toString(16)).append(nl);
        return buf.toString();
    }

    public byte[] encode() {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            buf.write(4);
            buf.write(this.x);
            buf.write(this.y);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buf.toByteArray();
    }

    public int size() {
        return 65;
    }

    public static int sizeof() {
        return 65;
    }
}

