/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.device.ibe;

import cn.com.infosec.common.logging.Logger;
import cn.com.infosec.common.logging.LoggerFactory;
import cn.com.infosec.device.ibe.Ibe;
import cn.com.infosec.device.sds.local.JARLibUtil;
import cn.com.infosec.device.util.JarUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipFile;

public class InfosecIbeSM9 {
    private static final Logger log = LoggerFactory.getLogger(InfosecIbeSM9.class);
    public static Ibe ibe = new Ibe();

    public static void main(String[] args) {
        System.out.println(System.getProperty("java.library.path"));
    }

    static void loadLib(ZipFile zf, String filename) {
        try {
            String outFileName = System.getProperty("java.io.tmpdir") + "/" + filename.substring(filename.lastIndexOf("/") + 1);
            File f = new File(outFileName);
            if (!f.exists()) {
                InputStream in = zf.getInputStream(zf.getEntry(filename));
                FileOutputStream out = new FileOutputStream(f);
                byte[] buf = new byte[1024];
                int len = -1;
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                in.close();
                out.close();
                JARLibUtil.addExec(f.getAbsolutePath());
            }
            System.load(f.getAbsolutePath());
            boolean flag = f.delete();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public static void initialize() {
        try {
            JarUtil util = new JarUtil(InfosecIbeSM9.class);
            ZipFile zf = new ZipFile(util.getJarPath() + "/" + util.getJarName());
            InfosecIbeSM9.loadLib(zf, InfosecIbeSM9.getJniLibName());
        }
        catch (Exception ex) {
            log.info("load ZipFile Exception ex= " + ex.getMessage());
            ex.printStackTrace();
            throw new UnsatisfiedLinkError(ex.getMessage());
        }
    }

    public static String getJniLibName() {
        int jvmArch = Integer.parseInt(System.getProperty("sun.arch.data.model"));
        String osArch = System.getProperty("os.arch");
        if (InfosecIbeSM9.isWindowsOS()) {
            switch (jvmArch) {
                case 32: {
                    return "lib/win32/device.dll_32";
                }
                case 64: {
                    return "lib/win64/device.dll_64";
                }
            }
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u865a\u62df\u673a\u67b6\u6784(System.getProperty(\"sun.arch.data.model\") = " + jvmArch + ")");
        }
        if (InfosecIbeSM9.isLinuxOS()) {
            switch (jvmArch) {
                case 32: {
                    if (osArch.equalsIgnoreCase("arm")) {
                        return "lib/arm32/libdevice.so_32";
                    }
                    return "lib/linux32/libdevice.so_32";
                }
                case 64: {
                    return "lib/linux64/libibesjni.so";
                }
            }
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u865a\u62df\u673a\u67b6\u6784(System.getProperty(\"sun.arch.data.model\") = " + jvmArch + ")");
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7cfb\u7edf(System.getProperty(\"os.name\") = " + System.getProperty("os.name") + ")");
    }

    public static void addExec(String filename) throws IOException {
        if (InfosecIbeSM9.isLinuxOS()) {
            String cmd = "chmod a+x " + filename;
            Process process = Runtime.getRuntime().exec(cmd);
        }
    }

    private static boolean isWindowsOS() {
        boolean isWindowsOS = false;
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().startsWith("windows")) {
            isWindowsOS = true;
        }
        return isWindowsOS;
    }

    private static boolean isLinuxOS() {
        boolean isWindowsOS = false;
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().startsWith("linux")) {
            isWindowsOS = true;
        }
        return isWindowsOS;
    }
}

