/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.device.sds;

import cn.com.infosec.device.bean.ECCrefKeyPair;
import cn.com.infosec.device.bean.ECCrefPrivateKey;
import cn.com.infosec.device.bean.ECCrefPublicKey;
import cn.com.infosec.device.bean.SM2refKeyPair;
import cn.com.infosec.device.bean.SM2refPrivateKey;
import cn.com.infosec.device.bean.SM2refPublicKey;
import cn.com.infosec.device.crypto.CryptoException;
import cn.com.infosec.device.crypto.ISDSCrypto;
import cn.com.infosec.device.sds.SymmAlgo;

public class CryptoDevice
implements ISDSCrypto {
    public static final int MAX_LENGTH = 7680;
    private ISDSCrypto crypto = null;

    public CryptoDevice(ISDSCrypto crypto) {
        this.crypto = crypto;
    }

    @Override
    public byte[] encrypt(String mode, String padding, byte[] key, byte[] iv, byte[] ad, int adlen, int macSize, byte[] input) throws CryptoException {
        SymmAlgo algo = new SymmAlgo();
        if (key == null) {
            throw new CryptoException("\u5bc6\u94a5\u4e3a\u7a7a");
        }
        if (input == null) {
            throw new CryptoException("\u8f93\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        if (!mode.equalsIgnoreCase("CCM") && padding.equalsIgnoreCase("NoPadding") && input.length % algo.getBlockLen() != 0) {
            throw new CryptoException("\u8f93\u5165\u6570\u636e\u975e\u5206\u7ec4\u957f\u5ea6\u7684\u6574\u6570\u500d");
        }
        if (mode.equalsIgnoreCase("CBC")) {
            if (iv == null) {
                iv = new byte[algo.getIvBlockLen()];
            } else if (iv.length != algo.getIvBlockLen()) {
                throw new CryptoException("\u521d\u59cb\u5316\u5411\u91cf\u975e\u5206\u7ec4\u957f\u5ea6");
            }
        }
        return this.crypto.encrypt(mode, padding, key, iv, ad, adlen, macSize, input);
    }

    @Override
    public byte[] decrypt(String mode, String padding, byte[] key, byte[] iv, byte[] ad, int adlen, int macSize, byte[] input) throws CryptoException {
        SymmAlgo algo = new SymmAlgo();
        if (key == null) {
            throw new CryptoException("\u5bc6\u94a5\u4e3a\u7a7a");
        }
        if (input == null) {
            throw new CryptoException("\u8f93\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        if (!mode.equalsIgnoreCase("CCM") && padding.equalsIgnoreCase("NoPadding") && input.length % algo.getBlockLen() != 0) {
            throw new CryptoException("\u8f93\u5165\u6570\u636e\u975e\u5206\u7ec4\u957f\u5ea6\u7684\u6574\u6570\u500d");
        }
        if (mode.equalsIgnoreCase("CBC")) {
            if (iv == null) {
                iv = new byte[algo.getIvBlockLen()];
            } else if (iv.length != algo.getIvBlockLen()) {
                throw new CryptoException("\u521d\u59cb\u5316\u5411\u91cf\u975e\u5206\u7ec4\u957f\u5ea6");
            }
        }
        return this.crypto.decrypt(mode, padding, key, iv, ad, adlen, macSize, input);
    }

    @Override
    public SM2refKeyPair generateSM2KeyPair(int keysize) throws CryptoException {
        try {
            return this.crypto.generateSM2KeyPair(keysize);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    @Override
    public byte[] sm2Encrypt(SM2refPublicKey refPublicKey, byte[] dataInput) throws CryptoException {
        try {
            return this.crypto.sm2Encrypt(refPublicKey, dataInput);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    @Override
    public byte[] sm2Decrypt(SM2refPrivateKey refPrivateKey, byte[] dataInput) throws CryptoException {
        try {
            return this.crypto.sm2Decrypt(refPrivateKey, dataInput);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    @Override
    public byte[] sm2Sign(SM2refPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        try {
            return this.crypto.sm2Sign(refPrivateKey, input);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    @Override
    public boolean sm2Verify(SM2refPublicKey refPublicKey, byte[] dataInput, byte[] refSig) throws CryptoException {
        try {
            return this.crypto.sm2Verify(refPublicKey, dataInput, refSig);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    @Override
    public byte[] keyAgreement_SM2(int flag, int keyIndex, SM2refPublicKey ownTmpPubKey, SM2refPrivateKey ownTmpPriKey, SM2refPublicKey opPubKey, SM2refPublicKey opTmpPubKey, int keyBits, byte[] ownId, byte[] opId) throws Exception {
        try {
            return this.crypto.keyAgreement_SM2(flag, keyIndex, ownTmpPubKey, ownTmpPriKey, opPubKey, opTmpPubKey, keyBits, ownId, opId);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    @Override
    public int[] getKeyStatus(int keyType) throws CryptoException {
        try {
            return this.crypto.getKeyStatus(keyType);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    @Override
    public byte[] genKCV(int keyIndex) throws CryptoException {
        try {
            return this.crypto.genKCV(keyIndex);
        }
        catch (Exception e) {
            throw new CryptoException(e.getMessage());
        }
    }

    @Override
    public String getCryptoName() {
        return this.crypto.getCryptoName();
    }

    @Override
    public byte[] calculateExtMAC(int algId, byte[] key, byte[] iv, byte[] input) throws CryptoException {
        SymmAlgo algo = new SymmAlgo();
        if (key == null) {
            throw new CryptoException("\u5bc6\u94a5\u4e3a\u7a7a");
        }
        if (input == null) {
            throw new CryptoException("\u8f93\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        if (iv != null && iv.length != algo.getIvBlockLen()) {
            throw new CryptoException("\u521d\u59cb\u5316\u5411\u91cf\u975e\u5206\u7ec4\u957f\u5ea6");
        }
        if (input.length % algo.getBlockLen() != 0) {
            throw new CryptoException("\u8f93\u5165\u6570\u636e\u975e\u5206\u7ec4\u957f\u5ea6\u7684\u6574\u6570\u500d");
        }
        if (iv == null) {
            iv = new byte[algo.getIvBlockLen()];
        }
        byte[] output = null;
        output = this.crypto.calculateExtMAC(algId, key, iv, input);
        return output;
    }

    @Override
    public byte[] calculateIntMAC(int algId, int keyIndex, byte[] iv, byte[] input) throws CryptoException {
        SymmAlgo algo = new SymmAlgo();
        if (keyIndex < 1 || keyIndex > 2176) {
            throw new CryptoException("\u975e\u6cd5\u7684\u5bc6\u94a5\u5e8f\u53f7( " + keyIndex + " )");
        }
        if (input == null) {
            throw new CryptoException("\u8f93\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        if (iv != null && iv.length != algo.getIvBlockLen()) {
            throw new CryptoException("\u521d\u59cb\u5316\u5411\u91cf\u975e\u5206\u7ec4\u957f\u5ea6");
        }
        if (input.length % algo.getBlockLen() != 0) {
            throw new CryptoException("\u8f93\u5165\u6570\u636e\u975e\u5206\u7ec4\u957f\u5ea6\u7684\u6574\u6570\u500d");
        }
        if (iv == null) {
            iv = new byte[algo.getIvBlockLen()];
        }
        byte[] output = null;
        output = this.crypto.calculateIntMAC(algId, keyIndex, iv, input);
        return output;
    }

    @Override
    public byte[] sm3Hash(byte[] input, int len, byte[] dgst) throws CryptoException {
        try {
            return this.crypto.sm3Hash(input, len, dgst);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    @Override
    public byte[] Sm2DerivePubkey(byte[] prvkey, int prvkey_len) throws CryptoException {
        try {
            return this.crypto.Sm2DerivePubkey(prvkey, prvkey_len);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    @Override
    public byte[] getZa(byte[] id, byte[] pub) throws CryptoException {
        try {
            return this.crypto.getZa(id, pub);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    @Override
    public byte[] sm2KeyExchange(byte[] self_id, int self_id_len, byte[] self_tmp_prvkey, int self_tmp_prvkey_len, byte[] self_tmp_pubkey, int self_tmp_pubkey_len, byte[] self_enc_prvkey, int self_enc_prvkey_len, byte[] self_enc_pubkey, int self_enc_pubkey_len, byte[] peer_id, int peer_id_len, byte[] peer_tmp_pubkey, int peer_tmp_pubkey_len, byte[] peer_enc_pubkey, int peer_enc_pubkey_len, boolean is_server) throws CryptoException {
        try {
            return this.crypto.sm2KeyExchange(self_id, self_id_len, self_tmp_prvkey, self_tmp_prvkey_len, self_tmp_pubkey, self_tmp_pubkey_len, self_enc_prvkey, self_enc_prvkey_len, self_enc_pubkey, self_enc_pubkey_len, peer_id, peer_id_len, peer_tmp_pubkey, peer_tmp_pubkey_len, peer_enc_pubkey, peer_enc_pubkey_len, is_server);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    @Override
    public ECCrefKeyPair generateECCKeyPair(int keysize) throws CryptoException {
        try {
            return this.crypto.generateECCKeyPair(keysize);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    @Override
    public byte[][] ecDsaSign(ECCrefPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        try {
            return this.crypto.ecDsaSign(refPrivateKey, input);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    @Override
    public boolean eccDsaVerify(ECCrefPublicKey refPublicKey, byte[] dataInput, byte[] r, byte[] s) throws CryptoException {
        try {
            return this.crypto.eccDsaVerify(refPublicKey, dataInput, r, s);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    @Override
    public byte[][] ecNrSign(ECCrefPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        try {
            return this.crypto.ecNrSign(refPrivateKey, input);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }

    @Override
    public boolean eccNrVerify(ECCrefPublicKey refPublicKey, byte[] dataInput, byte[] r, byte[] s) throws CryptoException {
        try {
            return this.crypto.eccNrVerify(refPublicKey, dataInput, r, s);
        }
        catch (Exception ex) {
            throw new CryptoException(ex.getMessage());
        }
    }
}

