/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.device.sds;

import cn.com.infosec.device.crypto.CryptoException;
import cn.com.infosec.device.ipp.rsa.HashAlgType;
import cn.com.infosec.device.ipp.rsa.IPPRsa;
import cn.com.infosec.device.ipp.rsa.IPPRsaKeyPair;
import cn.com.infosec.device.ipp.rsa.InfosecIPPRsa;

public class IPPRsaDevice {
    static InfosecIPPRsa ippRsa;
    static boolean inited;

    public IPPRsaDevice() throws CryptoException {
        try {
            IPPRsa.initialize();
            ippRsa = IPPRsa.ippRsa;
        }
        catch (Exception e) {
            throw new CryptoException(e.getMessage());
        }
    }

    public IPPRsaKeyPair generateRSAKeyPair(int keysize, int e) throws CryptoException {
        IPPRsaKeyPair keyPair = ippRsa.rsaKeyPair(keysize, e);
        if (keyPair == null) {
            throw new CryptoException("generate sm2 keypair error");
        }
        return keyPair;
    }

    public byte[] rsaEncrypt(byte[] plain, int plainlen, IPPRsaKeyPair keyPair) throws CryptoException {
        byte[] cipher = ippRsa.rsaEncrypt(plain, plainlen, keyPair);
        if (cipher == null) {
            throw new CryptoException("rsa encrypt error");
        }
        return cipher;
    }

    public byte[] rsaDecrypt(byte[] cipher, int cipherlen, IPPRsaKeyPair keyPair) throws CryptoException {
        byte[] plain = ippRsa.rsaDecrypt(cipher, cipherlen, keyPair);
        if (plain == null) {
            throw new CryptoException("rsa decrypt error");
        }
        return plain;
    }

    public byte[] rsaSignPKCSv15(byte[] plain, int plainlen, HashAlgType hashAlgoType, IPPRsaKeyPair keyPair) throws CryptoException {
        byte[] sign = ippRsa.rsaSignPKCSv15(plain, plainlen, hashAlgoType, keyPair);
        if (sign == null) {
            throw new CryptoException("rsa pkcs15 sign error");
        }
        return sign;
    }

    public boolean rsaVerifyPKCSv15(byte[] plain, int plainlen, byte[] sign, int signlen, HashAlgType hashAlgoType, IPPRsaKeyPair keyPair) throws CryptoException {
        boolean ret = ippRsa.rsaVerifyPKCSv15(plain, plainlen, sign, signlen, hashAlgoType, keyPair);
        if (!ret) {
            throw new CryptoException("rsa pkcs15 verify error");
        }
        return ret;
    }

    public byte[] rsaEncryptPKCSv15(byte[] plain, int plainlen, IPPRsaKeyPair keyPair) throws CryptoException {
        byte[] cipher = ippRsa.rsaEncryptPKCSv15(plain, plainlen, keyPair);
        if (cipher == null) {
            throw new CryptoException("rsa pkcs15 encrypt error");
        }
        return cipher;
    }

    public byte[] rsaDecryptPKCSv15(byte[] cipher, int cipherLen, IPPRsaKeyPair keyPair) throws CryptoException {
        byte[] plain = ippRsa.rsaDecryptPKCSv15(cipher, cipherLen, keyPair);
        if (plain == null) {
            throw new CryptoException("rsa pkcs15 verify error");
        }
        return plain;
    }

    public byte[] rsaSignPSS(byte[] plain, int plainlen, byte[] salt, int saltlen, HashAlgType hashAlgoType, IPPRsaKeyPair keyPair) throws CryptoException {
        byte[] sign = ippRsa.rsaSignPSS(plain, plainlen, salt, saltlen, hashAlgoType, keyPair);
        if (sign == null) {
            throw new CryptoException("rsa pss sign error");
        }
        return sign;
    }

    public boolean rsaVerifyPSS(byte[] plain, int plainlen, byte[] sign, int signlen, HashAlgType hashAlgoType, IPPRsaKeyPair keyPair) throws CryptoException {
        boolean ret = ippRsa.rsaVerifyPSS(plain, plainlen, sign, signlen, hashAlgoType, keyPair);
        if (!ret) {
            throw new CryptoException("rsa pss verify error");
        }
        return ret;
    }

    public byte[] rsaEncryptOAEP(byte[] plain, int plainlen, byte[] pin, int pinLen, HashAlgType hashAlgoType, IPPRsaKeyPair keyPair) throws CryptoException {
        byte[] cipher = ippRsa.rsaEncryptOAEP(plain, plainlen, pin, pinLen, hashAlgoType, keyPair);
        if (cipher == null) {
            throw new CryptoException("rsa oaep encrypt error");
        }
        return cipher;
    }

    public byte[] rsaDecryptOAEP(byte[] cipher, int cipherlen, byte[] pin, int pinLen, HashAlgType hashAlgoType, IPPRsaKeyPair keyPair) throws CryptoException {
        byte[] plain = ippRsa.rsaDecryptOAEP(cipher, cipherlen, pin, pinLen, hashAlgoType, keyPair);
        if (plain == null) {
            throw new CryptoException("rsa oaep decrypt error");
        }
        return plain;
    }

    static {
        inited = false;
    }
}

