/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.device.util;

import java.io.ByteArrayOutputStream;
import java.util.Random;

public class Bytes {
    public static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String delimiter = "";

    public static byte[] subbytes(byte[] bytes, int offset, int length) {
        byte[] buf = new byte[length];
        System.arraycopy(bytes, offset, buf, 0, length);
        return buf;
    }

    public static String bytes2hex(byte[] bytes) {
        return Bytes.bytes2hex(bytes, delimiter, bytes.length + 1);
    }

    public static byte[] hex2bytes(String str) {
        return Bytes.hex2bytes(str, delimiter);
    }

    private static byte[] hex2bytes(String str, String delimiter) {
        str = str.toLowerCase();
        if (delimiter.equals(delimiter)) {
            byte[] buf = new byte[str.length() / 2];
            for (int i = 0; i < buf.length; ++i) {
                char ch = str.charAt(i * 2);
                buf[i] = ch >= 'a' && ch <= 'f' ? (byte)(ch - 97 + 10 << 4) : (byte)(ch - 48 << 4);
                ch = str.charAt(i * 2 + 1);
                if (ch >= 'a' && ch <= 'f') {
                    int tmp104_102 = i;
                    byte[] tmp104_101 = buf;
                    tmp104_101[tmp104_102] = (byte)(tmp104_101[tmp104_102] + (byte)(ch - 97 + 10));
                    continue;
                }
                int tmp123_121 = i;
                byte[] tmp123_120 = buf;
                tmp123_120[tmp123_121] = (byte)(tmp123_120[tmp123_121] + (byte)(ch - 48));
            }
            return buf;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String[] arr = str.split(delimiter);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i].trim().equals(delimiter)) continue;
            baos.write(Bytes.hex2byte(arr[i]));
        }
        return baos.toByteArray();
    }

    private static String byte2hex(byte n) {
        String str = delimiter;
        str = str + HEX[(n & 0xF0) >> 4];
        str = str + HEX[n & 0xF];
        return str;
    }

    private static byte hex2byte(String str) {
        char ch = str.charAt(0);
        byte n = ch >= 'a' && ch <= 'f' ? (byte)(ch - 97 + 10 << 4) : (byte)(ch - 48 << 4);
        ch = str.charAt(1);
        n = ch >= 'a' && ch <= 'f' ? (byte)(n + (byte)(ch - 97 + 10)) : (byte)(n + (byte)(ch - 48));
        return n;
    }

    private static String bytes2hex(byte[] data, String delimiter, int wrap) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            if (i != 0 && i % wrap == 0) {
                sb.append("\n");
            }
            sb.append(Bytes.byte2hex(data[i]));
            sb.append(delimiter);
        }
        sb.append(", " + data.length);
        return sb.toString();
    }

    public static byte[] int2bytes(int num) {
        byte[] bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            bytes[i] = (byte)(0xFF & num >> i * 8);
        }
        return bytes;
    }

    public static byte[] int2bytesCat(int num, byte[] bytes, int offset) {
        for (int i = 0; i < 4; ++i) {
            bytes[offset + i] = (byte)(0xFF & num >> i * 8);
        }
        return bytes;
    }

    public static int bytes2int(byte[] bytes) {
        return Bytes.bytes2int(bytes, 0);
    }

    public static int bytes2int(byte[] bytes, int offset) {
        int num = 0;
        for (int i = 0; i < 4; ++i) {
            num += (0xFF & bytes[i + offset]) << i * 8;
        }
        return num;
    }

    public static void main(String[] args) {
        byte[] data = "asadafadsfewqf1312214r132rfwefwqt4q3tqwrefqew4r".getBytes();
        data = new byte[30];
        new Random().nextBytes(data);
        System.out.println(new String(data));
        System.out.println(Bytes.bytes2hex(data));
        byte[] data1 = Bytes.hex2bytes(Bytes.bytes2hex(data));
        System.out.println(new String(data1));
    }
}

