/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.device.util;

import cn.com.infosec.common.logging.Logger;
import cn.com.infosec.common.logging.LoggerFactory;
import cn.com.infosec.device.sds.local.JARLibUtil;
import cn.com.infosec.jcajce.util.PropertyUtils;
import cn.com.infosec.util.Platform;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public final class NativeLibraryLoader {
    private static final Logger log = LoggerFactory.getLogger(NativeLibraryLoader.class);
    private static boolean DELETE_NATIVE_LIB_AFTER_LOADING;
    private static String NATIVE_RESOURCE_NAME;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void load(ClassLoader loader) {
        File[] needDelete;
        File WORKDIR;
        String path = NATIVE_RESOURCE_NAME;
        String workdir = PropertyUtils.getStringSystemProperty("infosec.native.workdir");
        if (workdir != null) {
            File f = new File(workdir);
            f.mkdirs();
            try {
                f = f.getAbsoluteFile();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            WORKDIR = f;
        } else {
            workdir = PropertyUtils.getStringSystemProperty("java.io.tmpdir");
            WORKDIR = new File(workdir);
        }
        DELETE_NATIVE_LIB_AFTER_LOADING = PropertyUtils.getBooleanSystemProperty("infosec.native.deleteLibAfterLoading", true);
        if (Platform.isWindows() && (needDelete = WORKDIR.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().startsWith("infosec_");
            }
        })) != null && needDelete.length > 0) {
            for (File file : needDelete) {
                file.delete();
            }
            log.info("delete old dlls");
        }
        InputStream in = null;
        FileOutputStream out = null;
        File tmpFile = null;
        URL url = loader == null ? ClassLoader.getSystemResource(path) : loader.getResource(path);
        try {
            int length;
            int index = NATIVE_RESOURCE_NAME.lastIndexOf(47);
            int lastIndexOf = NATIVE_RESOURCE_NAME.lastIndexOf(46);
            String prefix = NATIVE_RESOURCE_NAME.substring(index + 1, lastIndexOf);
            String suffix = NATIVE_RESOURCE_NAME.substring(lastIndexOf);
            tmpFile = File.createTempFile(prefix + "_", suffix, WORKDIR);
            in = url.openStream();
            out = new FileOutputStream(tmpFile);
            byte[] buffer = new byte[4096];
            while ((length = in.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            out.flush();
            NativeLibraryLoader.closeQuietly(out);
            out = null;
            NativeLibraryLoader.loadLibrary(tmpFile.getPath(), true);
        }
        catch (UnsatisfiedLinkError e) {
            try {
                if (tmpFile != null && tmpFile.canRead() && tmpFile.isFile() && !tmpFile.canExecute()) {
                    log.error("[" + tmpFile.toString() + "] \u6587\u4ef6\u5b58\u5728, \u4f46\u65e0\u53ef\u6267\u884c\u6743\u9650, \u8bf7\u68c0\u67e5\u540e\u518d\u8bd5! \n" + "\u6216\u8005\u4f7f\u7528-Dinfosec.native.workdir, \u91cd\u65b0\u6307\u5b9a\u91ca\u653e\u76ee\u5f55. ");
                }
                log.error("\u52a0\u8f7d\u5e93\u6587\u4ef6 [" + tmpFile.getPath() + "] \u5931\u8d25: Load native library failed.\n Error Msg: " + e.getMessage());
                throw e;
                catch (Exception e2) {
                    UnsatisfiedLinkError ule = new UnsatisfiedLinkError("could not load a native library: " + tmpFile.getName());
                    ule.initCause(e2);
                    throw ule;
                }
            }
            catch (Throwable throwable) {
                NativeLibraryLoader.closeQuietly(in);
                NativeLibraryLoader.closeQuietly(out);
                if (Platform.isWindows()) throw throwable;
                if (tmpFile == null) throw throwable;
                if (DELETE_NATIVE_LIB_AFTER_LOADING) {
                    if (tmpFile.delete()) throw throwable;
                }
                tmpFile.deleteOnExit();
                throw throwable;
            }
        }
        NativeLibraryLoader.closeQuietly(in);
        NativeLibraryLoader.closeQuietly(out);
        if (Platform.isWindows()) return;
        if (tmpFile == null) return;
        if (DELETE_NATIVE_LIB_AFTER_LOADING) {
            if (tmpFile.delete()) return;
        }
        tmpFile.deleteOnExit();
    }

    public static void loadLibrary(String libName, boolean absolute) {
        if (absolute) {
            System.load(libName);
            log.info("load [" + libName + "] successful");
        } else {
            System.loadLibrary(libName);
        }
    }

    private static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        NATIVE_RESOURCE_NAME = JARLibUtil.getJniLibName();
    }
}

