/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ipp.crypto.signers;

import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.CryptoServicesRegistrar;
import cn.com.infosec.crypto.DSAExt;
import cn.com.infosec.crypto.RuntimeCryptoException;
import cn.com.infosec.crypto.params.ECDomainParameters;
import cn.com.infosec.crypto.params.ECKeyParameters;
import cn.com.infosec.crypto.params.ECPrivateKeyParameters;
import cn.com.infosec.crypto.params.ECPublicKeyParameters;
import cn.com.infosec.crypto.params.ParametersWithRandom;
import cn.com.infosec.device.SDSFactory;
import cn.com.infosec.device.bean.ECCrefPrivateKey;
import cn.com.infosec.device.bean.ECCrefPublicKey;
import cn.com.infosec.device.crypto.ISDSCrypto;
import cn.com.infosec.device.util.PrintUtil;
import cn.com.infosec.math.ec.ECConstants;
import cn.com.infosec.math.ec.ECFieldElement;
import cn.com.infosec.math.ec.ECMultiplier;
import cn.com.infosec.math.ec.ECPoint;
import cn.com.infosec.math.ec.FixedPointCombMultiplier;
import cn.com.infosec.util.BigIntegerUtil;
import cn.com.infosec.util.Debug;
import java.math.BigInteger;
import java.security.SecureRandom;

public class IPPECDSASigner
implements ECConstants,
DSAExt {
    private boolean forSigning;
    private ECKeyParameters key;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        this.forSigning = forSigning;
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.key = (ECPrivateKeyParameters)rParam.getParameters();
            } else {
                this.key = (ECPrivateKeyParameters)param;
            }
        } else {
            this.key = (ECPublicKeyParameters)param;
        }
    }

    @Override
    public BigInteger getOrder() {
        return this.key.getParameters().getN();
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        byte[][] signature;
        if (!this.forSigning) {
            throw new IllegalStateException("not initialised for signing");
        }
        if (this.key == null) {
            throw new IllegalStateException("ECC DSA sign engine not initialised");
        }
        ISDSCrypto device = null;
        try {
            device = SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        ECPrivateKeyParameters keyParam = (ECPrivateKeyParameters)this.key;
        byte[] d = BigIntegerUtil.asUnsigned32ByteArray(keyParam.getD());
        ECCrefPrivateKey privateKey = new ECCrefPrivateKey(d);
        try {
            signature = device.ecDsaSign(privateKey, message);
        }
        catch (Exception e) {
            Debug.println(Debug.ERROR, "eccSign error");
            System.err.println(privateKey);
            System.err.println("data input");
            System.err.println(PrintUtil.toHexString(message));
            throw new RuntimeCryptoException(e.getMessage());
        }
        return new BigInteger[]{BigIntegerUtil.toPositiveInteger(signature[0]), BigIntegerUtil.toPositiveInteger(signature[1])};
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        boolean flag;
        if (this.forSigning) {
            throw new IllegalStateException("not initialised for verifying");
        }
        if (this.key == null) {
            throw new IllegalStateException("ECC DSA sign engine not initialised");
        }
        ECDomainParameters ec = this.key.getParameters();
        BigInteger n = ec.getN();
        if (r.compareTo(ONE) < 0 || r.compareTo(n) >= 0) {
            return false;
        }
        if (s.compareTo(ONE) < 0 || s.compareTo(n) >= 0) {
            return false;
        }
        ISDSCrypto device = null;
        try {
            device = SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        ECPublicKeyParameters keyParam = (ECPublicKeyParameters)this.key;
        byte[] x = BigIntegerUtil.asUnsigned32ByteArray(keyParam.getQ().getAffineXCoord().toBigInteger());
        byte[] y = BigIntegerUtil.asUnsigned32ByteArray(keyParam.getQ().getAffineYCoord().toBigInteger());
        ECCrefPublicKey publicKey = new ECCrefPublicKey(x, y);
        try {
            flag = device.eccDsaVerify(publicKey, message, BigIntegerUtil.asUnsigned32ByteArray(r), BigIntegerUtil.asUnsigned32ByteArray(s));
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        return flag;
    }

    protected BigInteger calculateE(BigInteger n, byte[] message) {
        int log2n = n.bitLength();
        int messageBitLength = message.length * 8;
        BigInteger e = new BigInteger(1, message);
        if (log2n < messageBitLength) {
            e = e.shiftRight(messageBitLength - log2n);
        }
        return e;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    protected ECFieldElement getDenominator(int coordinateSystem, ECPoint p) {
        switch (coordinateSystem) {
            case 1: 
            case 6: 
            case 7: {
                return p.getZCoord(0);
            }
            case 2: 
            case 3: 
            case 4: {
                return p.getZCoord(0).square();
            }
        }
        return null;
    }

    protected SecureRandom initSecureRandom(boolean needed, SecureRandom provided) {
        return !needed ? null : (provided != null ? provided : CryptoServicesRegistrar.getSecureRandom());
    }
}

