/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ipp.crypto.signers;

import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.RuntimeCryptoException;
import cn.com.infosec.crypto.params.ParametersWithRandom;
import cn.com.infosec.crypto.params.RSAKeyParameters;
import cn.com.infosec.crypto.params.RSAPrivateCrtKeyParameters;
import cn.com.infosec.device.IPPRsaFactory;
import cn.com.infosec.device.ipp.rsa.HashAlgType;
import cn.com.infosec.device.ipp.rsa.IPPRsaKeyPair;
import cn.com.infosec.device.sds.IPPRsaDevice;
import cn.com.infosec.device.util.PrintUtil;
import cn.com.infosec.util.BigIntegerUtil;
import cn.com.infosec.util.Debug;
import java.security.SecureRandom;

public class IPPPSSSigner {
    private final HashAlgType digest;
    private RSAKeyParameters key;
    private SecureRandom random;
    private byte[] salt;
    private int saltLen;

    public IPPPSSSigner(HashAlgType digest, int sLen) {
        this.digest = digest;
        this.saltLen = sLen;
        this.salt = new byte[this.saltLen];
    }

    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (RSAPrivateCrtKeyParameters)rParam.getParameters();
            } else {
                this.random = new SecureRandom();
                this.key = (RSAPrivateCrtKeyParameters)param;
            }
        } else {
            this.key = (RSAKeyParameters)param;
        }
    }

    public byte[] generateSignature(byte[] message) {
        byte[] signature;
        if (this.key == null) {
            throw new IllegalStateException("RSA sign engine not initialised");
        }
        IPPRsaDevice device = null;
        try {
            device = IPPRsaFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        RSAPrivateCrtKeyParameters keyParam = (RSAPrivateCrtKeyParameters)this.key;
        int keyBytes = (keyParam.getP().bitLength() + 7) / 8;
        IPPRsaKeyPair keyPair = new IPPRsaKeyPair(keyParam.getPublicExponent().intValue(), BigIntegerUtil.asUnsignedNByteArray(keyParam.getModulus(), (keyParam.getModulus().bitLength() + 7) / 8), null, BigIntegerUtil.asUnsignedNByteArray(keyParam.getP(), keyBytes), BigIntegerUtil.asUnsignedNByteArray(keyParam.getQ(), keyBytes), BigIntegerUtil.asUnsignedNByteArray(keyParam.getDP(), keyBytes), BigIntegerUtil.asUnsignedNByteArray(keyParam.getDQ(), keyBytes), BigIntegerUtil.asUnsignedNByteArray(keyParam.getQInv(), keyBytes));
        if (this.saltLen != 0) {
            if (this.salt == null) {
                this.salt = new byte[this.saltLen];
            }
            this.random.nextBytes(this.salt);
        }
        try {
            signature = device.rsaSignPSS(message, message.length, this.salt, this.saltLen, this.digest, keyPair);
        }
        catch (Exception e) {
            Debug.println(Debug.ERROR, "RSA PSS Sign error");
            System.err.println("data input");
            System.err.println(PrintUtil.toHexString(message));
            throw new RuntimeCryptoException(e.getMessage());
        }
        return signature;
    }

    public boolean verifySignature(byte[] message, byte[] sign) {
        boolean flag;
        if (this.key == null) {
            throw new IllegalStateException("RSA sign engine not initialised");
        }
        IPPRsaDevice device = null;
        try {
            device = IPPRsaFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        int keyBytes = (this.key.getModulus().bitLength() + 7) / 8;
        IPPRsaKeyPair keyPair = new IPPRsaKeyPair(this.key.getExponent().intValue(), BigIntegerUtil.asUnsignedNByteArray(this.key.getModulus(), keyBytes), null, null, null, null, null, null);
        try {
            flag = device.rsaVerifyPSS(message, message.length, sign, sign.length, this.digest, keyPair);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        return flag;
    }
}

