/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ipp.crypto.signers;

import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.RuntimeCryptoException;
import cn.com.infosec.crypto.params.ECKeyParameters;
import cn.com.infosec.crypto.params.ECPrivateKeyParameters;
import cn.com.infosec.crypto.params.ECPublicKeyParameters;
import cn.com.infosec.crypto.params.ParametersWithRandom;
import cn.com.infosec.device.SDSFactory;
import cn.com.infosec.device.bean.SM2refPrivateKey;
import cn.com.infosec.device.bean.SM2refPublicKey;
import cn.com.infosec.device.crypto.ISDSCrypto;
import cn.com.infosec.device.util.PrintUtil;
import cn.com.infosec.util.BigIntegerUtil;
import cn.com.infosec.util.Debug;

public class IPPSM2Signer {
    private ECKeyParameters key;

    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.key = (ECPrivateKeyParameters)rParam.getParameters();
            } else {
                this.key = (ECPrivateKeyParameters)param;
            }
        } else {
            this.key = (ECPublicKeyParameters)param;
        }
    }

    public byte[] generateSignature(byte[] message) {
        if (this.key == null) {
            throw new IllegalStateException("SM2 sign engine not initialised");
        }
        byte[] signature = null;
        ISDSCrypto device = null;
        try {
            device = SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        ECPrivateKeyParameters keyParam = (ECPrivateKeyParameters)this.key;
        byte[] d = BigIntegerUtil.asUnsigned32ByteArray(keyParam.getD());
        SM2refPrivateKey privateKey = new SM2refPrivateKey(d);
        try {
            signature = device.sm2Sign(privateKey, message);
        }
        catch (Exception e) {
            Debug.println(Debug.ERROR, "sm2Sign error");
            System.err.println(privateKey);
            System.err.println("data input");
            System.err.println(PrintUtil.toHexString(message));
            throw new RuntimeCryptoException(e.getMessage());
        }
        return signature;
    }

    public boolean verifySignature(byte[] message, byte[] sig) {
        boolean flag;
        if (this.key == null) {
            throw new IllegalStateException("SM2 sign engine not initialised");
        }
        ISDSCrypto device = null;
        try {
            device = SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        ECPublicKeyParameters keyParam = (ECPublicKeyParameters)this.key;
        byte[] x = BigIntegerUtil.asUnsigned32ByteArray(keyParam.getQ().getAffineXCoord().toBigInteger());
        byte[] y = BigIntegerUtil.asUnsigned32ByteArray(keyParam.getQ().getAffineYCoord().toBigInteger());
        SM2refPublicKey publicKey = new SM2refPublicKey(x, y);
        try {
            flag = device.sm2Verify(publicKey, message, sig);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        return flag;
    }
}

