/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ipp.crypto.signers;

import cn.com.infosec.asn1.gm.SM9CurveParameters;
import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.Digest;
import cn.com.infosec.crypto.RuntimeCryptoException;
import cn.com.infosec.crypto.digests.SM3Digest;
import cn.com.infosec.crypto.params.ParametersWithRandom;
import cn.com.infosec.crypto.params.SM9KeyParameters;
import cn.com.infosec.crypto.params.SM9PrivateKeyParameters;
import cn.com.infosec.crypto.params.SM9PublicKeyParameters;
import cn.com.infosec.crypto.signers.DSAEncoding;
import cn.com.infosec.crypto.signers.StandardDSAEncoding;
import cn.com.infosec.device.IBEFactory;
import cn.com.infosec.device.ibe.UserPublicKey;
import cn.com.infosec.device.sds.IBEDevice;
import cn.com.infosec.device.util.PrintUtil;
import cn.com.infosec.math.ec.ECMultiplier;
import cn.com.infosec.math.ec.FixedPointCombMultiplier;
import cn.com.infosec.util.Debug;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SM9Signer {
    private final Digest digest;
    private SM9KeyParameters key;
    private SecureRandom random;
    private String randData;
    private final DSAEncoding encoding;
    private byte[] z;

    public SM9Signer() {
        this(StandardDSAEncoding.INSTANCE, new SM3Digest());
    }

    public SM9Signer(Digest digest) {
        this(StandardDSAEncoding.INSTANCE, digest);
    }

    public SM9Signer(DSAEncoding encoding) {
        this.encoding = encoding;
        this.digest = new SM3Digest();
    }

    public SM9Signer(DSAEncoding encoding, Digest digest) {
        this.encoding = encoding;
        this.digest = digest;
    }

    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (SM9KeyParameters)rParam.getParameters();
            } else {
                this.random = new SecureRandom();
                this.key = (SM9KeyParameters)param;
            }
        } else {
            this.key = (SM9KeyParameters)param;
        }
    }

    public byte[] generateSignature(byte[] message) {
        byte[] signature;
        if (this.key == null) {
            throw new IllegalStateException("SM9 sign engine not initialised");
        }
        IBEDevice device = null;
        try {
            device = IBEFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        SM9PrivateKeyParameters keyParam = (SM9PrivateKeyParameters)this.key;
        BigInteger r = BigInteger.ZERO;
        while ((r = new BigInteger(256, new SecureRandom())).equals(BigInteger.ZERO) || r.compareTo(SM9CurveParameters.N) >= 0) {
        }
        try {
            signature = device.sm9Sign(keyParam.getZzn12Sign(), keyParam.getParameters(), message, r.toByteArray());
        }
        catch (Exception e) {
            Debug.println(Debug.ERROR, "sm2Sign error");
            System.err.println(keyParam.getParameters());
            System.err.println("data input");
            System.err.println(PrintUtil.toHexString(message));
            throw new RuntimeCryptoException(e.getMessage());
        }
        return signature;
    }

    public void update(byte b) {
        this.digest.update(b);
    }

    public void update(byte[] in, int off, int len) {
        this.digest.update(in, off, len);
    }

    public boolean verifySignature(byte[] message, byte[] sign) {
        boolean flag;
        if (this.key == null) {
            throw new IllegalStateException("SM2 sign engine not initialised");
        }
        IBEDevice device = null;
        try {
            device = IBEFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        SM9PublicKeyParameters keyParam = (SM9PublicKeyParameters)this.key;
        UserPublicKey refPublicKey = new UserPublicKey();
        refPublicKey.len = keyParam.getIdlen();
        refPublicKey.pid = keyParam.getUid();
        refPublicKey.reseved = keyParam.getParameters();
        try {
            flag = device.sm9Verify(keyParam.getZzn12Sign(), refPublicKey, message, sign);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        return flag;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

