/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ipp.provider;

import cn.com.infosec.asn1.ASN1ObjectIdentifier;
import cn.com.infosec.asn1.pkcs.PrivateKeyInfo;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.crypto.RuntimeCryptoException;
import cn.com.infosec.device.SDSFactory;
import cn.com.infosec.ipp.provider.ISFJProviderConfiguration;
import cn.com.infosec.jcajce.provider.config.ConfigurableProvider;
import cn.com.infosec.jcajce.provider.config.ProviderConfiguration;
import cn.com.infosec.jcajce.provider.symmetric.util.ClassUtil;
import cn.com.infosec.jcajce.provider.util.AlgorithmProvider;
import cn.com.infosec.jcajce.provider.util.AsymmetricKeyInfoConverter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;

public final class ISFJProvider
extends Provider
implements ConfigurableProvider {
    private static String info = "INFOSEC Security Provider v2.0.1.3";
    public static final String PROVIDER_NAME = "ISFJ";
    public static final ProviderConfiguration CONFIGURATION = new ISFJProviderConfiguration();
    private static final Map keyInfoConverters = new HashMap();
    private static final String SYMMETRIC_PACKAGE = "cn.com.infosec.ipp.provider.symmetric.";
    private static final String[] SYMMETRIC_CIPHERS = new String[]{"SM4"};
    private static final String ASYMMETRIC_PACKAGE = "cn.com.infosec.ipp.provider.asymmetric.";
    private static final String[] ASYMMETRIC_CIPHERS = new String[]{"RSA", "SM2", "SM9", "EC"};
    private static final String DIGEST_PACKAGE = "cn.com.infosec.ipp.provider.digest.";
    private static final String[] DIGESTS = new String[]{"SM3"};

    public ISFJProvider() {
        super(PROVIDER_NAME, 1.0, info);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ISFJProvider.this.setup();
                return null;
            }
        });
        try {
            SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("\u8fde\u63a5\u6c60\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5JCE\u914d\u7f6e\u6587\u4ef6. Error=" + e.getMessage());
        }
    }

    private void setup() {
        this.loadAlgorithms(DIGEST_PACKAGE, DIGESTS);
        this.loadAlgorithms(SYMMETRIC_PACKAGE, SYMMETRIC_CIPHERS);
        this.loadAlgorithms(ASYMMETRIC_PACKAGE, ASYMMETRIC_CIPHERS);
    }

    private void loadAlgorithms(String packageName, String[] names) {
        for (int i = 0; i != names.length; ++i) {
            Class clazz = ClassUtil.loadClass(ISFJProvider.class, packageName + names[i] + "$Mappings");
            if (clazz == null) continue;
            try {
                ((AlgorithmProvider)clazz.newInstance()).configure(this);
                continue;
            }
            catch (Exception e) {
                throw new InternalError("cannot create instance of " + packageName + names[i] + "$Mappings : " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameter(String parameterName, Object parameter) {
        ProviderConfiguration providerConfiguration = CONFIGURATION;
        synchronized (providerConfiguration) {
            ((ISFJProviderConfiguration)CONFIGURATION).setParameter(parameterName, parameter);
        }
    }

    @Override
    public boolean hasAlgorithm(String type, String name) {
        return this.containsKey(type + "." + name) || this.containsKey("Alg.Alias." + type + "." + name);
    }

    @Override
    public void addAlgorithm(String key, String value) {
        if (this.containsKey(key)) {
            throw new IllegalStateException("duplicate provider key (" + key + ") found");
        }
        this.put(key, value);
    }

    @Override
    public void addAlgorithm(String type, ASN1ObjectIdentifier oid, String className) {
        this.addAlgorithm(type + "." + oid, className);
        this.addAlgorithm(type + ".OID." + oid, className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addKeyInfoConverter(ASN1ObjectIdentifier oid, AsymmetricKeyInfoConverter keyInfoConverter) {
        Map map = keyInfoConverters;
        synchronized (map) {
            keyInfoConverters.put(oid, keyInfoConverter);
        }
    }

    @Override
    public void addAttributes(String key, Map<String, String> attributeMap) {
        for (String attributeName : attributeMap.keySet()) {
            String attributeKey = key + " " + attributeName;
            if (this.containsKey(attributeKey)) {
                throw new IllegalStateException("duplicate provider attribute key (" + attributeKey + ") found");
            }
            this.put(attributeKey, attributeMap.get(attributeName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AsymmetricKeyInfoConverter getAsymmetricKeyInfoConverter(ASN1ObjectIdentifier algorithm) {
        Map map = keyInfoConverters;
        synchronized (map) {
            return (AsymmetricKeyInfoConverter)keyInfoConverters.get(algorithm);
        }
    }

    public static PublicKey getPublicKey(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter converter = ISFJProvider.getAsymmetricKeyInfoConverter(publicKeyInfo.getAlgorithm().getAlgorithm());
        if (converter == null) {
            return null;
        }
        return converter.generatePublic(publicKeyInfo);
    }

    public static PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter converter = ISFJProvider.getAsymmetricKeyInfoConverter(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm());
        if (converter == null) {
            return null;
        }
        return converter.generatePrivate(privateKeyInfo);
    }
}

