/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ipp.provider.asymmetric.rsa;

import cn.com.infosec.asn1.ASN1ObjectIdentifier;
import cn.com.infosec.asn1.nist.NISTObjectIdentifiers;
import cn.com.infosec.asn1.oiw.OIWObjectIdentifiers;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.x509.DigestInfo;
import cn.com.infosec.crypto.AsymmetricBlockCipher;
import cn.com.infosec.crypto.Digest;
import cn.com.infosec.crypto.InvalidCipherTextException;
import cn.com.infosec.crypto.encodings.PKCS1Encoding;
import cn.com.infosec.crypto.engines.IPPRSACoreEngine;
import cn.com.infosec.crypto.params.RSAKeyParameters;
import cn.com.infosec.crypto.util.DigestFactory;
import cn.com.infosec.device.ipp.rsa.HashAlgType;
import cn.com.infosec.ipp.crypto.signers.IPPRSADigestSigner;
import cn.com.infosec.ipp.provider.asymmetric.rsa.RSAUtil;
import cn.com.infosec.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public class IPPDigestSignatureSpi
extends SignatureSpi {
    private IPPRSADigestSigner signer;
    private AsymmetricBlockCipher cipher;
    private ByteArrayOutputStream buf;

    protected IPPDigestSignatureSpi(IPPRSADigestSigner signer) {
        this.signer = signer;
        this.buf = new ByteArrayOutputStream();
    }

    public IPPDigestSignatureSpi(AsymmetricBlockCipher ipprsaCoreEngine) {
        this.cipher = ipprsaCoreEngine;
        this.buf = new ByteArrayOutputStream();
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Supplied key (" + this.getType(publicKey) + ") is not a RSAPublicKey instance");
        }
        RSAKeyParameters param = RSAUtil.generatePublicKeyParameter((RSAPublicKey)publicKey);
        if (this.signer != null) {
            this.signer.init(false, param);
        } else if (this.cipher != null) {
            this.cipher.init(false, param);
        }
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key (" + this.getType(privateKey) + ") is not a RSAPrivateKey instance");
        }
        RSAKeyParameters param = RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey);
        this.signer.init(true, param);
    }

    private String getType(Object o) {
        if (o == null) {
            return null;
        }
        return o.getClass().getName();
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.buf.write(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.buf.write(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (this.buf.size() == 0) {
            throw new SignatureException("the input data size is 0");
        }
        try {
            byte[] message = this.buf.toByteArray();
            this.buf.reset();
            return this.signer.generateSignature(message);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SignatureException("key too small for signature type");
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        if (this.buf.size() == 0) {
            throw new SignatureException("the input data size is 0");
        }
        byte[] message = this.buf.toByteArray();
        this.buf.reset();
        if (this.signer != null) {
            return this.signer.verifySignature(message, sigBytes);
        }
        byte[] result = null;
        try {
            Digest digest;
            result = this.cipher.processBlock(sigBytes, 0, sigBytes.length);
            DigestInfo hashinfo = DigestInfo.getInstance(result);
            ASN1ObjectIdentifier algorithm = hashinfo.getAlgorithmId().getAlgorithm();
            if (algorithm.equals(OIWObjectIdentifiers.idSHA1)) {
                digest = DigestFactory.createSHA1();
            } else if (algorithm.equals(NISTObjectIdentifiers.id_sha224)) {
                digest = DigestFactory.createSHA224();
            } else if (algorithm.equals(NISTObjectIdentifiers.id_sha256)) {
                digest = DigestFactory.createSHA256();
            } else if (algorithm.equals(NISTObjectIdentifiers.id_sha384)) {
                digest = DigestFactory.createSHA384();
            } else if (algorithm.equals(NISTObjectIdentifiers.id_sha512)) {
                digest = DigestFactory.createSHA512();
            } else if (algorithm.equals(PKCSObjectIdentifiers.md5)) {
                digest = DigestFactory.createMD5();
            } else if (algorithm.equals(NISTObjectIdentifiers.id_sha512_224)) {
                digest = DigestFactory.createSHA512_224();
            } else if (algorithm.equals(NISTObjectIdentifiers.id_sha512_256)) {
                digest = DigestFactory.createSHA512_256();
            } else if (algorithm.equals(PKCSObjectIdentifiers.id_sha256_sm3)) {
                digest = DigestFactory.create256_SM3();
            } else {
                throw new SignatureException("hash unavailable with RSA.");
            }
            byte[] hash = new byte[digest.getDigestSize()];
            digest.update(message, 0, message.length);
            digest.doFinal(hash, 0);
            if (hash.length == hashinfo.getDigest().length) {
                return Arrays.constantTimeAreEqual(hash, hashinfo.getDigest());
            }
            return false;
        }
        catch (InvalidCipherTextException e) {
            return false;
        }
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    public static class SHA512_256
    extends IPPDigestSignatureSpi {
        public SHA512_256() {
            super(new IPPRSADigestSigner(HashAlgType.SHA512_256));
        }
    }

    public static class SHA512_224
    extends IPPDigestSignatureSpi {
        public SHA512_224() {
            super(new IPPRSADigestSigner(HashAlgType.SHA512_224));
        }
    }

    public static class SM3
    extends IPPDigestSignatureSpi {
        public SM3() {
            super(new IPPRSADigestSigner(HashAlgType.SM3));
        }
    }

    public static class MD5
    extends IPPDigestSignatureSpi {
        public MD5() {
            super(new IPPRSADigestSigner(HashAlgType.MD5));
        }
    }

    public static class SHA512
    extends IPPDigestSignatureSpi {
        public SHA512() {
            super(new IPPRSADigestSigner(HashAlgType.SHA512));
        }
    }

    public static class SHA384
    extends IPPDigestSignatureSpi {
        public SHA384() {
            super(new IPPRSADigestSigner(HashAlgType.SHA384));
        }
    }

    public static class SHA256
    extends IPPDigestSignatureSpi {
        public SHA256() {
            super(new IPPRSADigestSigner(HashAlgType.SHA256));
        }
    }

    public static class SHA224
    extends IPPDigestSignatureSpi {
        public SHA224() {
            super(new IPPRSADigestSigner(HashAlgType.SHA224));
        }
    }

    public static class SHA1
    extends IPPDigestSignatureSpi {
        public SHA1() {
            super(new IPPRSADigestSigner(HashAlgType.SHA1));
        }
    }

    public static class UNKNOWN
    extends IPPDigestSignatureSpi {
        public UNKNOWN() {
            super(new PKCS1Encoding(new IPPRSACoreEngine()));
        }
    }
}

