/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ipp.provider.asymmetric.rsa;

import cn.com.infosec.crypto.params.ParametersWithRandom;
import cn.com.infosec.crypto.params.RSAKeyParameters;
import cn.com.infosec.device.ipp.rsa.HashAlgType;
import cn.com.infosec.ipp.crypto.signers.IPPPSSSigner;
import cn.com.infosec.ipp.provider.asymmetric.rsa.RSAUtil;
import cn.com.infosec.jcajce.spec.IPPPSSParameterSpec;
import cn.com.infosec.jcajce.util.ISFJJcaJceHelper;
import cn.com.infosec.jcajce.util.JcaJceHelper;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public class PSSSignatureSpi
extends SignatureSpi {
    private final JcaJceHelper helper = new ISFJJcaJceHelper();
    private AlgorithmParameters engineParams;
    private IPPPSSSigner signer;
    private HashAlgType digest;
    private IPPPSSParameterSpec paramSpec;
    private IPPPSSParameterSpec originalSpec;
    private ByteArrayOutputStream buf;
    private int saltLength;
    private boolean isInitState = true;
    private RSAKeyParameters key;

    protected PSSSignatureSpi(IPPPSSParameterSpec baseParamSpec) {
        this.paramSpec = baseParamSpec == null ? IPPPSSParameterSpec.DEFAULT : baseParamSpec;
        this.digest = this.paramSpec.getDigest();
        this.saltLength = this.paramSpec.getSaltLength();
        this.signer = new IPPPSSSigner(this.digest, this.saltLength);
        this.buf = new ByteArrayOutputStream();
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Supplied key is not a RSAPublicKey instance");
        }
        this.key = RSAUtil.generatePublicKeyParameter((RSAPublicKey)publicKey);
        this.signer.init(false, this.key);
        this.isInitState = true;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key is not a RSAPrivateKey instance");
        }
        this.key = RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey);
        this.signer.init(true, new ParametersWithRandom(this.key, random));
        this.isInitState = true;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key is not a RSAPrivateKey instance");
        }
        this.key = RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey);
        this.signer.init(true, this.key);
        this.isInitState = true;
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.buf.write(b);
        this.isInitState = false;
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.buf.write(b, off, len);
        this.isInitState = false;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        this.isInitState = true;
        if (this.buf.size() == 0) {
            throw new SignatureException("the input data size is 0");
        }
        try {
            byte[] message = this.buf.toByteArray();
            this.buf.reset();
            return this.signer.generateSignature(message);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SignatureException("key too small for signature type");
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        this.isInitState = true;
        if (this.buf.size() == 0) {
            throw new SignatureException("the input data size is 0");
        }
        byte[] message = this.buf.toByteArray();
        this.buf.reset();
        return this.signer.verifySignature(message, sigBytes);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params == null) {
            if (this.originalSpec != null) {
                params = this.originalSpec;
            } else {
                return;
            }
        }
        if (!this.isInitState) {
            throw new ProviderException("cannot call setParameter in the middle of update");
        }
        if (params instanceof IPPPSSParameterSpec) {
            IPPPSSParameterSpec newParamSpec = (IPPPSSParameterSpec)params;
            if (this.originalSpec != null && this.originalSpec.getDigest() != newParamSpec.getDigest()) {
                throw new InvalidAlgorithmParameterException("parameter must be using " + (Object)((Object)this.originalSpec.getDigest()));
            }
            this.engineParams = null;
            this.paramSpec = newParamSpec;
            this.saltLength = this.paramSpec.getSaltLength();
            this.digest = this.paramSpec.getDigest();
            if (this.key != null) {
                this.signer = new IPPPSSSigner(this.digest, this.saltLength);
                if (this.key.isPrivate()) {
                    this.signer.init(true, this.key);
                } else {
                    this.signer.init(false, this.key);
                }
            }
        } else {
            throw new InvalidAlgorithmParameterException("Only PSSParameterSpec supported");
        }
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.paramSpec != null) {
            try {
                this.engineParams = this.helper.createAlgorithmParameters("PSS");
                this.engineParams.init(this.paramSpec);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
        return this.engineParams;
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineGetParameter unsupported");
    }

    public static class SHA512_256withRSA
    extends PSSSignatureSpi {
        public SHA512_256withRSA() {
            super(new IPPPSSParameterSpec(HashAlgType.SHA512_256, 32));
        }
    }

    public static class SHA512_224withRSA
    extends PSSSignatureSpi {
        public SHA512_224withRSA() {
            super(new IPPPSSParameterSpec(HashAlgType.SHA512_224, 28));
        }
    }

    public static class SHA512withRSA
    extends PSSSignatureSpi {
        public SHA512withRSA() {
            super(new IPPPSSParameterSpec(HashAlgType.SHA512, 64));
        }
    }

    public static class SHA384withRSA
    extends PSSSignatureSpi {
        public SHA384withRSA() {
            super(new IPPPSSParameterSpec(HashAlgType.SHA384, 48));
        }
    }

    public static class MD5withRSA
    extends PSSSignatureSpi {
        public MD5withRSA() {
            super(new IPPPSSParameterSpec(HashAlgType.MD5, 16));
        }
    }

    public static class SHA256withRSA
    extends PSSSignatureSpi {
        public SHA256withRSA() {
            super(new IPPPSSParameterSpec(HashAlgType.SHA256, 32));
        }
    }

    public static class SHA224withRSA
    extends PSSSignatureSpi {
        public SHA224withRSA() {
            super(new IPPPSSParameterSpec(HashAlgType.SHA224, 28));
        }
    }

    public static class SHA1withRSA
    extends PSSSignatureSpi {
        public SHA1withRSA() {
            super(IPPPSSParameterSpec.DEFAULT);
        }
    }

    public static class PSSwithRSA
    extends PSSSignatureSpi {
        public PSSwithRSA() {
            super(null);
        }
    }
}

