/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ipp.provider.asymmetric.sm2;

import cn.com.infosec.asn1.ASN1ObjectIdentifier;
import cn.com.infosec.asn1.x9.ECNamedCurveTable;
import cn.com.infosec.asn1.x9.X9ECParameters;
import cn.com.infosec.crypto.AsymmetricCipherKeyPair;
import cn.com.infosec.crypto.generators.SM2KeyPairGenerator;
import cn.com.infosec.crypto.params.ECDomainParameters;
import cn.com.infosec.crypto.params.ECKeyGenerationParameters;
import cn.com.infosec.crypto.params.ECPrivateKeyParameters;
import cn.com.infosec.crypto.params.ECPublicKeyParameters;
import cn.com.infosec.jcajce.provider.asymmetric.sm2.SM2PrivateKey;
import cn.com.infosec.jcajce.provider.asymmetric.sm2.SM2PublicKey;
import cn.com.infosec.jcajce.provider.asymmetric.util.EC5Util;
import cn.com.infosec.jcajce.provider.config.ProviderConfiguration;
import cn.com.infosec.jce.provider.INFOSECProvider;
import cn.com.infosec.jce.spec.ECNamedCurveGenParameterSpec;
import cn.com.infosec.jce.spec.ECNamedCurveSpec;
import cn.com.infosec.math.ec.ECCurve;
import cn.com.infosec.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;

public abstract class KeyPairGeneratorSpi
extends KeyPairGenerator {
    public KeyPairGeneratorSpi(String algorithmName) {
        super(algorithmName);
    }

    public static class SM2
    extends KeyPairGeneratorSpi {
        ECKeyGenerationParameters param;
        SM2KeyPairGenerator engine = new SM2KeyPairGenerator();
        Object ecParams = null;
        int strength = 239;
        int certainty = 50;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;
        String algorithm;
        ProviderConfiguration configuration;

        public SM2() {
            super("SM2");
            this.algorithm = "SM2";
            this.configuration = INFOSECProvider.CONFIGURATION;
        }

        public SM2(String algorithm, ProviderConfiguration configuration) {
            super(algorithm);
            this.algorithm = algorithm;
            this.configuration = configuration;
        }

        @Override
        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
            ECGenParameterSpec ecParams = new ECGenParameterSpec("prime256v1_sm2");
            if (ecParams != null) {
                try {
                    this.initialize(ecParams, random);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new InvalidParameterException("key size not configurable.");
                }
            } else {
                throw new InvalidParameterException("unknown key size.");
            }
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (params instanceof cn.com.infosec.jce.spec.ECParameterSpec) {
                cn.com.infosec.jce.spec.ECParameterSpec p = (cn.com.infosec.jce.spec.ECParameterSpec)params;
                this.ecParams = params;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN()), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params instanceof ECParameterSpec) {
                ECParameterSpec p = (ECParameterSpec)params;
                this.ecParams = params;
                ECCurve curve = EC5Util.convertCurve(p.getCurve());
                ECPoint g = EC5Util.convertPoint(curve, p.getGenerator(), false);
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(curve, g, p.getOrder(), BigInteger.valueOf(p.getCofactor())), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params instanceof ECGenParameterSpec || params instanceof ECNamedCurveGenParameterSpec) {
                String curveName = params instanceof ECGenParameterSpec ? ((ECGenParameterSpec)params).getName() : ((ECNamedCurveGenParameterSpec)params).getName();
                X9ECParameters ecP = ECNamedCurveTable.getByName(curveName);
                if (ecP == null) {
                    try {
                        ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(curveName);
                        ecP = ECNamedCurveTable.getByOID(oid);
                        if (ecP == null) {
                            throw new InvalidAlgorithmParameterException("unknown curve OID: " + curveName);
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        throw new InvalidAlgorithmParameterException("unknown curve name: " + curveName);
                    }
                }
                this.ecParams = new ECNamedCurveSpec(curveName, ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), null);
                ECParameterSpec p = (ECParameterSpec)this.ecParams;
                ECCurve curve = EC5Util.convertCurve(p.getCurve());
                ECPoint g = EC5Util.convertPoint(curve, p.getGenerator(), false);
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(curve, g, p.getOrder(), BigInteger.valueOf(p.getCofactor())), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params == null && this.configuration.getEcImplicitlyCa() != null) {
                cn.com.infosec.jce.spec.ECParameterSpec p = this.configuration.getEcImplicitlyCa();
                this.ecParams = params;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN()), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else {
                if (params == null && this.configuration.getEcImplicitlyCa() == null) {
                    throw new InvalidAlgorithmParameterException("null parameter passed but no implicitCA set");
                }
                throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec");
            }
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                this.initialize(this.strength, new SecureRandom());
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            ECPublicKeyParameters pub = (ECPublicKeyParameters)pair.getPublic();
            ECPrivateKeyParameters priv = (ECPrivateKeyParameters)pair.getPrivate();
            if (this.ecParams instanceof cn.com.infosec.jce.spec.ECParameterSpec) {
                cn.com.infosec.jce.spec.ECParameterSpec p = (cn.com.infosec.jce.spec.ECParameterSpec)this.ecParams;
                SM2PublicKey pubKey = new SM2PublicKey(this.algorithm, pub, p, this.configuration);
                return new KeyPair(pubKey, new SM2PrivateKey(this.algorithm, priv, pubKey, p, this.configuration));
            }
            if (this.ecParams == null) {
                return new KeyPair(new SM2PublicKey(this.algorithm, pub, this.configuration), new SM2PrivateKey(this.algorithm, priv, this.configuration));
            }
            ECParameterSpec p = (ECParameterSpec)this.ecParams;
            SM2PublicKey pubKey = new SM2PublicKey(this.algorithm, pub, p, this.configuration);
            return new KeyPair(pubKey, new SM2PrivateKey(this.algorithm, priv, pubKey, p, this.configuration));
        }
    }
}

