/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ipp.provider.asymmetric.sm2;

import cn.com.infosec.asn1.ASN1Primitive;
import cn.com.infosec.asn1.DERBitString;
import cn.com.infosec.asn1.DLSequence;
import cn.com.infosec.asn1.DLTaggedObject;
import cn.com.infosec.asn1.pkcs.PrivateKeyInfo;
import cn.com.infosec.crypto.Digest;
import cn.com.infosec.crypto.RuntimeCryptoException;
import cn.com.infosec.crypto.digests.IPPSM3Digest;
import cn.com.infosec.crypto.params.AsymmetricKeyParameter;
import cn.com.infosec.crypto.params.ECKeyParameters;
import cn.com.infosec.crypto.params.ECPrivateKeyParameters;
import cn.com.infosec.crypto.params.ECPublicKeyParameters;
import cn.com.infosec.crypto.params.ParametersWithRandom;
import cn.com.infosec.device.SDSFactory;
import cn.com.infosec.device.crypto.CryptoException;
import cn.com.infosec.device.crypto.ISDSCrypto;
import cn.com.infosec.ipp.crypto.signers.IPPSM2Signer;
import cn.com.infosec.jcajce.provider.asymmetric.sm2.SM2PrivateKey;
import cn.com.infosec.jcajce.provider.asymmetric.util.ECUtil;
import cn.com.infosec.jcajce.spec.SM2ParameterSpec;
import cn.com.infosec.math.ec.ECPoint;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class SignatureSpi
extends java.security.SignatureSpi {
    boolean inited = false;
    byte[] paddPrefix = new byte[0];
    private ECKeyParameters key;
    private SM2ParameterSpec paramSpec;
    protected Digest digest;
    protected IPPSM2Signer signer;

    SignatureSpi(Digest digest, IPPSM2Signer signer) {
        this.digest = digest;
        this.signer = signer;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        AsymmetricKeyParameter param = ECUtil.generatePublicKeyParameter(publicKey);
        this.digest.reset();
        this.signer.init(false, param);
        this.key = (ECPublicKeyParameters)param;
        byte[] userID = null;
        if (this.paramSpec != null) {
            userID = this.paramSpec.getID();
        }
        ECPoint P = ((ECPublicKeyParameters)this.key).getQ();
        ISDSCrypto device = null;
        try {
            device = SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        try {
            this.paddPrefix = device.getZa(userID, P.getEncoded());
        }
        catch (CryptoException e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        this.inited = false;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        AsymmetricKeyParameter param = ECUtil.generatePrivateKeyParameter(privateKey);
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)((Object)param);
            this.key = (ECPrivateKeyParameters)rParam.getParameters();
        } else {
            this.key = (ECPrivateKeyParameters)param;
        }
        byte[] userID = null;
        if (this.paramSpec != null) {
            userID = this.paramSpec.getID();
        }
        ISDSCrypto device = null;
        try {
            device = SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        byte[] pub = null;
        if (privateKey instanceof SM2PrivateKey) {
            try {
                PrivateKeyInfo info = PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(privateKey.getEncoded()));
                DLSequence privKey = (DLSequence)info.parsePrivateKey();
                DLTaggedObject ob = (DLTaggedObject)privKey.getObjectAt(3);
                DERBitString bit = (DERBitString)ob.getObject();
                pub = bit.getBytes();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            pub = device.Sm2DerivePubkey(((ECPrivateKeyParameters)this.key).getD().toByteArray(), 32);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        try {
            this.paddPrefix = device.getZa(userID, pub);
        }
        catch (CryptoException e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        this.digest.reset();
        if (this.appRandom != null) {
            this.signer.init(true, new ParametersWithRandom(param, this.appRandom));
        } else {
            this.signer.init(true, param);
        }
        this.inited = false;
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.digest.update(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.digest.update(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            return this.signer.generateSignature(hash);
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        return this.signer.verifySignature(hash, sigBytes);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (!(params instanceof SM2ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("only SM2ParameterSpec supported");
        }
        this.paramSpec = (SM2ParameterSpec)params;
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        return null;
    }

    public static class SM2
    extends SignatureSpi {
        public SM2() {
            super(new IPPSM3Digest(), new IPPSM2Signer());
            this.inited = false;
        }

        @Override
        protected void engineUpdate(byte b) throws SignatureException {
            byte[] tbhash = new byte[]{b};
            if (!this.inited) {
                tbhash = new byte[1 + this.paddPrefix.length];
                System.arraycopy(this.paddPrefix, 0, tbhash, 0, this.paddPrefix.length);
                tbhash[this.paddPrefix.length] = b;
                super.engineUpdate(tbhash, 0, 1 + this.paddPrefix.length);
                this.inited = true;
            } else {
                super.engineUpdate(b);
            }
        }

        @Override
        protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
            byte[] tbhash = b;
            if (!this.inited) {
                tbhash = new byte[len + this.paddPrefix.length];
                System.arraycopy(this.paddPrefix, 0, tbhash, 0, this.paddPrefix.length);
                System.arraycopy(b, off, tbhash, this.paddPrefix.length, len);
                super.engineUpdate(tbhash, 0, len + this.paddPrefix.length);
                this.inited = true;
            } else {
                super.engineUpdate(b, off, len);
            }
        }
    }
}

