/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ipp.provider.asymmetric.sm9;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1Integer;
import cn.com.infosec.asn1.ASN1ObjectIdentifier;
import cn.com.infosec.asn1.ASN1Primitive;
import cn.com.infosec.asn1.DERBitString;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DLSequence;
import cn.com.infosec.asn1.DLTaggedObject;
import cn.com.infosec.asn1.gm.GMObjectIdentifiers;
import cn.com.infosec.asn1.gm.SM9PrivateKey;
import cn.com.infosec.asn1.pkcs.PrivateKeyInfo;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.crypto.params.SM9KeyParameters;
import cn.com.infosec.crypto.params.SM9PrivateKeyParameters;
import cn.com.infosec.ipp.provider.asymmetric.sm9.SM9MasterPublicKey;
import cn.com.infosec.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import cn.com.infosec.jcajce.provider.config.ProviderConfiguration;
import cn.com.infosec.jce.spec.SM9PrivateKeySpec;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;
import java.util.Enumeration;

public class SM9MasterPrivateKey
implements PrivateKey {
    static final long serialVersionUID = 994553197664784084L;
    private String algorithm = "SM9";
    private boolean withCompression;
    private transient byte[] zzn12sign;
    private transient byte[] zzn12enc;
    private transient byte[] d;
    private transient ProviderConfiguration configuration;
    private transient DERBitString publicKey;
    private transient PKCS12BagAttributeCarrierImpl attrCarrier = new PKCS12BagAttributeCarrierImpl();

    protected SM9MasterPrivateKey() {
    }

    public SM9MasterPrivateKey(String algorithm, SM9MasterPrivateKey key) {
        this.algorithm = algorithm;
        this.zzn12sign = key.zzn12sign;
        this.zzn12enc = key.zzn12enc;
        this.d = key.d;
        this.withCompression = key.withCompression;
        this.attrCarrier = key.attrCarrier;
        this.publicKey = key.publicKey;
        this.configuration = key.configuration;
    }

    public SM9MasterPrivateKey(String algorithm, SM9PrivateKeySpec spec, ProviderConfiguration configuration) {
        this.algorithm = algorithm;
        this.zzn12sign = spec.getZzn12Sign();
        this.zzn12enc = spec.getZzn12Enc();
        this.d = spec.getD();
        this.configuration = configuration;
    }

    public SM9MasterPrivateKey(String algorithm, SM9KeyParameters params, SM9MasterPublicKey pubKey, ProviderConfiguration configuration) {
        this.algorithm = algorithm;
        this.zzn12sign = params.getZzn12Sign();
        this.zzn12enc = params.getZzn12Enc();
        this.d = params.getParameters();
        this.configuration = configuration;
        this.publicKey = this.getPublicKeyDetails(pubKey);
    }

    public SM9MasterPrivateKey(String algorithm, SM9PrivateKeyParameters params, ProviderConfiguration configuration) {
        this.algorithm = algorithm;
        this.zzn12sign = params.getZzn12Sign();
        this.zzn12enc = params.getZzn12Enc();
        this.d = params.getParameters();
        this.configuration = configuration;
    }

    SM9MasterPrivateKey(String algorithm, PrivateKeyInfo info, ProviderConfiguration configuration) throws IOException {
        this.algorithm = algorithm;
        this.configuration = configuration;
        this.populateFromPrivKeyInfo(info);
    }

    private void populateFromPrivKeyInfo(PrivateKeyInfo info) throws IOException {
        ASN1Encodable privKey = info.parsePrivateKey();
        if (privKey instanceof ASN1Integer) {
            ASN1Integer derD = ASN1Integer.getInstance(privKey);
            this.d = derD.getEncoded();
        } else {
            DLSequence seq = (DLSequence)privKey.toASN1Primitive();
            DEROctetString zznsign = (DEROctetString)seq.getObjectAt(1);
            this.zzn12sign = zznsign.getOctets();
            DEROctetString zznenc = (DEROctetString)seq.getObjectAt(2);
            this.zzn12enc = zznenc.getOctets();
            DEROctetString prv = (DEROctetString)seq.getObjectAt(3);
            this.d = prv.getOctets();
            DLTaggedObject pub = (DLTaggedObject)seq.getObjectAt(4);
            this.publicKey = (DERBitString)pub.getObject();
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        SM9PrivateKey keyStructure = this.publicKey != null ? new SM9PrivateKey(this.zzn12sign, this.zzn12enc, this.d, this.publicKey) : new SM9PrivateKey(this.d);
        try {
            PrivateKeyInfo info = new PrivateKeyInfo(new AlgorithmIdentifier(GMObjectIdentifiers.id_sm9PublicKey), keyStructure);
            return info.getEncoded("DER");
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setBagAttribute(ASN1ObjectIdentifier oid, ASN1Encodable attribute) {
        this.attrCarrier.setBagAttribute(oid, attribute);
    }

    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier oid) {
        return this.attrCarrier.getBagAttribute(oid);
    }

    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }

    public void setPointFormat(String style) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(style);
    }

    public byte[] getS() {
        return this.d;
    }

    public byte[] getD() {
        return this.d;
    }

    public byte[] getZzn12Sign() {
        return this.zzn12sign;
    }

    public byte[] getZzn12Enc() {
        return this.zzn12enc;
    }

    private DERBitString getPublicKeyDetails(SM9MasterPublicKey pub) {
        try {
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(pub.getEncoded()));
            return info.getPublicKeyData();
        }
        catch (IOException e) {
            return null;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

