/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ipp.provider.asymmetric.sm9;

import cn.com.infosec.asn1.ASN1Integer;
import cn.com.infosec.asn1.ASN1Primitive;
import cn.com.infosec.asn1.DERBitString;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DLSequence;
import cn.com.infosec.asn1.gm.GMObjectIdentifiers;
import cn.com.infosec.asn1.gm.SM9UserPublicKeyInfo;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.crypto.params.ECDomainParameters;
import cn.com.infosec.crypto.params.SM9UserPublicKeyParameters;
import cn.com.infosec.jcajce.provider.config.ProviderConfiguration;
import cn.com.infosec.jce.provider.INFOSECProvider;
import cn.com.infosec.jce.spec.SM9PublicKeySpec;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;

public class SM9UserPublicKey
implements PublicKey {
    private static final long serialVersionUID = -168162404531251651L;
    private String algorithm = "SM9";
    private boolean withCompression;
    private transient int idlen;
    private transient byte[] uid;
    private transient byte[] zzn12sign;
    private transient byte[] zzn12enc;
    private transient byte[] q;
    private transient ProviderConfiguration configuration;

    public SM9UserPublicKey(String algorithm, SM9UserPublicKey key) {
        this.algorithm = algorithm;
        this.zzn12sign = key.zzn12sign;
        this.zzn12enc = key.zzn12enc;
        this.q = key.q;
        this.idlen = key.idlen;
        this.uid = key.uid;
        this.configuration = key.configuration;
    }

    public SM9UserPublicKey(String algorithm, SM9UserPublicKeyParameters pub, ProviderConfiguration configuration) {
        this.algorithm = algorithm;
        this.idlen = pub.getIdlen();
        this.uid = pub.getUid();
        this.zzn12sign = pub.getZzn12Sign();
        this.zzn12enc = pub.getZzn12Enc();
        this.q = pub.getParameters();
        this.configuration = configuration;
    }

    SM9UserPublicKey(String algorithm, SubjectPublicKeyInfo info, ProviderConfiguration configuration) {
        this.algorithm = algorithm;
        this.configuration = configuration;
        this.populateFromPubKeyInfo(info);
    }

    public SM9UserPublicKey(String algorithm, SM9PublicKeySpec keySpec, ProviderConfiguration configuration) {
        this.algorithm = algorithm;
        this.zzn12sign = keySpec.getZzn12Sign();
        this.zzn12enc = keySpec.getZzn12Enc();
        this.q = keySpec.getQ();
        this.configuration = configuration;
    }

    private ECParameterSpec createSpec(EllipticCurve ellipticCurve, ECDomainParameters dp) {
        return new ECParameterSpec(ellipticCurve, new ECPoint(dp.getG().getAffineXCoord().toBigInteger(), dp.getG().getAffineYCoord().toBigInteger()), dp.getN(), dp.getH().intValue());
    }

    private void populateFromPubKeyInfo(SubjectPublicKeyInfo info) {
        DERBitString bits = info.getPublicKeyData();
        byte[] octects = bits.getOctets();
        DLSequence key = (DLSequence)DLSequence.getInstance(octects);
        this.zzn12sign = ((DEROctetString)key.getObjectAt(0)).getOctets();
        this.zzn12enc = ((DEROctetString)key.getObjectAt(1)).getOctets();
        this.idlen = ((ASN1Integer)key.getObjectAt(2)).getValue().intValue();
        this.uid = ((DEROctetString)key.getObjectAt(3)).getOctets();
        this.q = ((DEROctetString)key.getObjectAt(4)).getOctets();
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        SM9UserPublicKeyInfo keyStructure = new SM9UserPublicKeyInfo(this.zzn12sign, this.zzn12enc, this.idlen, this.uid, this.q);
        try {
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(GMObjectIdentifiers.id_sm9PublicKey), keyStructure);
            return info.getEncoded("DER");
        }
        catch (IOException e) {
            return null;
        }
    }

    private void extractBytes(byte[] encKey, int offSet, BigInteger bI) {
        byte[] val = bI.toByteArray();
        if (val.length < 32) {
            byte[] tmp = new byte[32];
            System.arraycopy(val, 0, tmp, tmp.length - val.length, val.length);
            val = tmp;
        }
        for (int i = 0; i != 32; ++i) {
            encKey[offSet + i] = val[val.length - 1 - i];
        }
    }

    int getIdLen() {
        return this.idlen;
    }

    byte[] getUid() {
        return this.uid;
    }

    public byte[] getQ() {
        return this.q;
    }

    public byte[] getZzn12Sign() {
        return this.zzn12sign;
    }

    public byte[] getZzn12Enc() {
        return this.zzn12enc;
    }

    public void setPointFormat(String style) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(style);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.populateFromPubKeyInfo(SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(enc)));
        this.configuration = INFOSECProvider.CONFIGURATION;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

