/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ipp.provider.asymmetric.sm9;

import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Integer;
import cn.com.infosec.asn1.ASN1Primitive;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.crypto.params.SM9KeyParameters;
import cn.com.infosec.crypto.params.SM9PrivateKeyParameters;
import cn.com.infosec.crypto.params.SM9PublicKeyParameters;
import cn.com.infosec.crypto.signers.StandardDSAEncoding;
import cn.com.infosec.ipp.crypto.signers.SM9Signer;
import cn.com.infosec.ipp.provider.asymmetric.sm9.SM9UserPrivateKey;
import cn.com.infosec.ipp.provider.asymmetric.sm9.SM9UserPublicKey;
import cn.com.infosec.jcajce.provider.asymmetric.util.DSAEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;

public abstract class SignatureSpi
extends java.security.SignatureSpi {
    private SM9KeyParameters key;
    private SM9Signer signer;
    private ByteArrayOutputStream buf;

    public SignatureSpi(SM9Signer sm9Signer, StandardDSAEncoding instance) {
        this.signer = sm9Signer;
        this.buf = new ByteArrayOutputStream();
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        SM9UserPublicKey pubKey = null;
        if (!(publicKey instanceof SM9UserPublicKey)) {
            throw new InvalidKeyException("can't identify SM9 public key.");
        }
        pubKey = (SM9UserPublicKey)publicKey;
        SM9PublicKeyParameters param = new SM9PublicKeyParameters(pubKey.getZzn12Sign(), null, pubKey.getIdLen(), pubKey.getUid(), pubKey.getQ());
        this.key = param;
        this.signer.init(false, param);
        this.buf.reset();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        SM9UserPrivateKey prvKey = null;
        if (!(privateKey instanceof SM9UserPrivateKey)) {
            throw new InvalidKeyException("can't identify SM9 private key.");
        }
        prvKey = (SM9UserPrivateKey)privateKey;
        SM9PrivateKeyParameters param = new SM9PrivateKeyParameters(prvKey.getZzn12sign(), null, prvKey.getD());
        this.key = param;
        this.signer.init(true, param);
        this.buf.reset();
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.buf.write(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (this.buf.size() == 0) {
            throw new SignatureException("the input data size is 0");
        }
        try {
            byte[] message = this.buf.toByteArray();
            this.buf.reset();
            return this.signer.generateSignature(message);
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        if (this.buf.size() == 0) {
            throw new SignatureException("the input data size is 0");
        }
        byte[] message = this.buf.toByteArray();
        this.buf.reset();
        return this.signer.verifySignature(message, sigBytes);
    }

    private static class CVCDSAEncoder
    implements DSAEncoder {
        private CVCDSAEncoder() {
        }

        @Override
        public byte[] encode(BigInteger r, BigInteger s) throws IOException {
            byte[] second;
            byte[] first = this.makeUnsigned(r);
            byte[] res = first.length > (second = this.makeUnsigned(s)).length ? new byte[first.length * 2] : new byte[second.length * 2];
            System.arraycopy(first, 0, res, res.length / 2 - first.length, first.length);
            System.arraycopy(second, 0, res, res.length - second.length, second.length);
            return res;
        }

        private byte[] makeUnsigned(BigInteger val) {
            byte[] res = val.toByteArray();
            if (res[0] == 0) {
                byte[] tmp = new byte[res.length - 1];
                System.arraycopy(res, 1, tmp, 0, tmp.length);
                return tmp;
            }
            return res;
        }

        @Override
        public BigInteger[] decode(byte[] encoding) throws IOException {
            BigInteger[] sig = new BigInteger[2];
            byte[] first = new byte[encoding.length / 2];
            byte[] second = new byte[encoding.length / 2];
            System.arraycopy(encoding, 0, first, 0, first.length);
            System.arraycopy(encoding, first.length, second, 0, second.length);
            sig[0] = new BigInteger(1, first);
            sig[1] = new BigInteger(1, second);
            return sig;
        }
    }

    private static class StdDSAEncoder
    implements DSAEncoder {
        private StdDSAEncoder() {
        }

        @Override
        public byte[] encode(BigInteger r, BigInteger s) throws IOException {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(new ASN1Integer(r));
            v.add(new ASN1Integer(s));
            return new DERSequence(v).getEncoded("DER");
        }

        @Override
        public BigInteger[] decode(byte[] encoding) throws IOException {
            ASN1Sequence s = (ASN1Sequence)ASN1Primitive.fromByteArray(encoding);
            BigInteger[] sig = new BigInteger[]{ASN1Integer.getInstance(s.getObjectAt(0)).getValue(), ASN1Integer.getInstance(s.getObjectAt(1)).getValue()};
            return sig;
        }
    }

    public static class SM9
    extends SignatureSpi {
        public SM9() {
            super(new SM9Signer(), StandardDSAEncoding.INSTANCE);
        }

        @Override
        protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
            super.engineUpdate(b, off, len);
        }

        @Override
        protected void engineUpdate(byte b) throws SignatureException {
            throw new UnsupportedOperationException("engineSetParameter unsupported");
        }

        @Override
        protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
            throw new UnsupportedOperationException("engineSetParameter unsupported");
        }

        @Override
        protected Object engineGetParameter(String param) throws InvalidParameterException {
            throw new UnsupportedOperationException("engineSetParameter unsupported");
        }
    }
}

