/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ipp.provider.digest;

import cn.com.infosec.asn1.gm.GMObjectIdentifiers;
import cn.com.infosec.crypto.CipherKeyGenerator;
import cn.com.infosec.crypto.digests.IPPSM3Digest;
import cn.com.infosec.crypto.macs.HMac;
import cn.com.infosec.ipp.provider.digest.DigestAlgorithmProvider;
import cn.com.infosec.ipp.provider.digest.IPPMessageDigest;
import cn.com.infosec.jcajce.provider.config.ConfigurableProvider;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseMac;

public class SM3 {
    private SM3() {
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SM3.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.SM3", PREFIX + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest.SM3", "SM3");
            provider.addAlgorithm("Alg.Alias.MessageDigest.1.2.156.197.1.401", "SM3");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + GMObjectIdentifiers.sm3, "SM3");
            this.addHMACAlgorithm(provider, "SM3", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
            this.addHMACAlias(provider, "SM3", GMObjectIdentifiers.hmac_sm3);
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACSM3", 256, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new IPPSM3Digest()));
        }
    }

    public static class Digest
    extends IPPMessageDigest
    implements Cloneable {
        public Digest() {
            super(new IPPSM3Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new IPPSM3Digest(this.digest);
            return d;
        }
    }
}

