/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jcajce.provider.asymmetric.ecgost12;

import cn.com.infosec.asn1.sec.ECPrivateKey;
import cn.com.infosec.asn1.x9.X9IntegerConverter;
import cn.com.infosec.crypto.DerivationFunction;
import cn.com.infosec.crypto.agreement.INFOSECVKOAgreement;
import cn.com.infosec.crypto.digests.GOST3411_2012_256Digest;
import cn.com.infosec.crypto.digests.GOST3411_2012_512Digest;
import cn.com.infosec.crypto.params.AsymmetricKeyParameter;
import cn.com.infosec.crypto.params.ECDomainParameters;
import cn.com.infosec.crypto.params.ECPrivateKeyParameters;
import cn.com.infosec.crypto.params.ParametersWithUKM;
import cn.com.infosec.jcajce.provider.asymmetric.ecgost12.INFOSECECGOST3410_2012PublicKey;
import cn.com.infosec.jcajce.provider.asymmetric.util.BaseAgreementSpi;
import cn.com.infosec.jcajce.provider.asymmetric.util.ECUtil;
import cn.com.infosec.jcajce.spec.UserKeyingMaterialSpec;
import cn.com.infosec.jce.interfaces.INFOSECPublicKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class KeyAgreementSpi
extends BaseAgreementSpi {
    private static final X9IntegerConverter converter = new X9IntegerConverter();
    private String kaAlgorithm;
    private ECDomainParameters parameters;
    private INFOSECVKOAgreement agreement;
    private byte[] result;

    protected KeyAgreementSpi(String kaAlgorithm, INFOSECVKOAgreement agreement, DerivationFunction kdf) {
        super(kaAlgorithm, kdf);
        this.kaAlgorithm = kaAlgorithm;
        this.agreement = agreement;
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (this.parameters == null) {
            throw new IllegalStateException(this.kaAlgorithm + " not initialised.");
        }
        if (!lastPhase) {
            throw new IllegalStateException(this.kaAlgorithm + " can only be between two parties.");
        }
        if (!(key instanceof PublicKey)) {
            throw new InvalidKeyException(this.kaAlgorithm + " key agreement requires " + KeyAgreementSpi.getSimpleName(INFOSECPublicKey.class) + " for doPhase");
        }
        AsymmetricKeyParameter pubKey = KeyAgreementSpi.generatePublicKeyParameter((PublicKey)key);
        try {
            this.result = this.agreement.calculateAgreement(pubKey);
        }
        catch (Exception e) {
            throw new InvalidKeyException("calculation failed: " + e.getMessage()){

                @Override
                public Throwable getCause() {
                    return e;
                }
            };
        }
        return null;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null && !(params instanceof UserKeyingMaterialSpec)) {
            throw new InvalidAlgorithmParameterException("No algorithm parameters supported");
        }
        this.initFromKey(key, params);
    }

    @Override
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        this.initFromKey(key, null);
    }

    private void initFromKey(Key key, AlgorithmParameterSpec parameterSpec) throws InvalidKeyException {
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException(this.kaAlgorithm + " key agreement requires " + KeyAgreementSpi.getSimpleName(ECPrivateKey.class) + " for initialisation");
        }
        ECPrivateKeyParameters privKey = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)key);
        this.parameters = privKey.getParameters();
        this.ukmParameters = parameterSpec instanceof UserKeyingMaterialSpec ? ((UserKeyingMaterialSpec)parameterSpec).getUserKeyingMaterial() : null;
        this.agreement.init(new ParametersWithUKM(privKey, this.ukmParameters));
    }

    private static String getSimpleName(Class clazz) {
        String fullName = clazz.getName();
        return fullName.substring(fullName.lastIndexOf(46) + 1);
    }

    static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        return key instanceof INFOSECECGOST3410_2012PublicKey ? ((INFOSECECGOST3410_2012PublicKey)key).engineGetKeyParameters() : ECUtil.generatePublicKeyParameter(key);
    }

    @Override
    protected byte[] calcSecret() {
        return this.result;
    }

    public static class ECVKO512
    extends KeyAgreementSpi {
        public ECVKO512() {
            super("ECGOST3410-2012-512", new INFOSECVKOAgreement(new GOST3411_2012_512Digest()), null);
        }
    }

    public static class ECVKO256
    extends KeyAgreementSpi {
        public ECVKO256() {
            super("ECGOST3410-2012-256", new INFOSECVKOAgreement(new GOST3411_2012_256Digest()), null);
        }
    }
}

