/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jcajce.provider.asymmetric.edec;

import cn.com.infosec.asn1.edec.EdECObjectIdentifiers;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.crypto.params.AsymmetricKeyParameter;
import cn.com.infosec.crypto.params.Ed25519PublicKeyParameters;
import cn.com.infosec.crypto.params.Ed448PublicKeyParameters;
import cn.com.infosec.jcajce.interfaces.EdDSAKey;
import cn.com.infosec.jcajce.provider.asymmetric.edec.KeyFactorySpi;
import cn.com.infosec.jcajce.provider.asymmetric.edec.Utils;
import cn.com.infosec.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;

public class INFOSECEdDSAPublicKey
implements EdDSAKey,
PublicKey {
    static final long serialVersionUID = 1L;
    private transient AsymmetricKeyParameter eddsaPublicKey;

    INFOSECEdDSAPublicKey(AsymmetricKeyParameter pubKey) {
        this.eddsaPublicKey = pubKey;
    }

    INFOSECEdDSAPublicKey(SubjectPublicKeyInfo keyInfo) {
        this.populateFromPubKeyInfo(keyInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    INFOSECEdDSAPublicKey(byte[] prefix, byte[] rawData) throws InvalidKeySpecException {
        int prefixLength = prefix.length;
        if (!Utils.isValidPrefix(prefix, rawData)) throw new InvalidKeySpecException("raw key data not recognised");
        if (rawData.length - prefixLength == 57) {
            this.eddsaPublicKey = new Ed448PublicKeyParameters(rawData, prefixLength);
            return;
        } else {
            if (rawData.length - prefixLength != 32) throw new InvalidKeySpecException("raw key data not recognised");
            this.eddsaPublicKey = new Ed25519PublicKeyParameters(rawData, prefixLength);
        }
    }

    private void populateFromPubKeyInfo(SubjectPublicKeyInfo keyInfo) {
        this.eddsaPublicKey = EdECObjectIdentifiers.id_Ed448.equals(keyInfo.getAlgorithm().getAlgorithm()) ? new Ed448PublicKeyParameters(keyInfo.getPublicKeyData().getOctets(), 0) : new Ed25519PublicKeyParameters(keyInfo.getPublicKeyData().getOctets(), 0);
    }

    @Override
    public String getAlgorithm() {
        return this.eddsaPublicKey instanceof Ed448PublicKeyParameters ? "Ed448" : "Ed25519";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        if (this.eddsaPublicKey instanceof Ed448PublicKeyParameters) {
            byte[] encoding = new byte[KeyFactorySpi.Ed448Prefix.length + 57];
            System.arraycopy(KeyFactorySpi.Ed448Prefix, 0, encoding, 0, KeyFactorySpi.Ed448Prefix.length);
            ((Ed448PublicKeyParameters)this.eddsaPublicKey).encode(encoding, KeyFactorySpi.Ed448Prefix.length);
            return encoding;
        }
        byte[] encoding = new byte[KeyFactorySpi.Ed25519Prefix.length + 32];
        System.arraycopy(KeyFactorySpi.Ed25519Prefix, 0, encoding, 0, KeyFactorySpi.Ed25519Prefix.length);
        ((Ed25519PublicKeyParameters)this.eddsaPublicKey).encode(encoding, KeyFactorySpi.Ed25519Prefix.length);
        return encoding;
    }

    AsymmetricKeyParameter engineGetKeyParameters() {
        return this.eddsaPublicKey;
    }

    public String toString() {
        return Utils.keyToString("Public Key", this.getAlgorithm(), this.eddsaPublicKey);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof INFOSECEdDSAPublicKey)) {
            return false;
        }
        INFOSECEdDSAPublicKey other = (INFOSECEdDSAPublicKey)o;
        return Arrays.areEqual(other.getEncoded(), this.getEncoded());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.populateFromPubKeyInfo(SubjectPublicKeyInfo.getInstance(enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

