/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jcajce.provider.asymmetric.util;

import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.x509.X509ObjectIdentifiers;
import cn.com.infosec.crypto.DSAExt;
import cn.com.infosec.crypto.Digest;
import cn.com.infosec.crypto.signers.DSAEncoding;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;

public abstract class DSABase
extends SignatureSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    protected Digest digest;
    protected DSAExt signer;
    protected DSAEncoding encoding;

    protected DSABase(Digest digest, DSAExt signer, DSAEncoding encoding) {
        this.digest = digest;
        this.signer = signer;
        this.encoding = encoding;
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.digest.update(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.digest.update(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            BigInteger[] sig = this.signer.generateSignature(hash);
            return this.encoding.encode(this.signer.getOrder(), sig[0], sig[1]);
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        BigInteger[] sig;
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            sig = this.encoding.decode(this.signer.getOrder(), sigBytes);
        }
        catch (Exception e) {
            throw new SignatureException("error decoding signature bytes.");
        }
        return this.signer.verifySignature(hash, sig[0], sig[1]);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }
}

