/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jcajce.provider.asymmetric.util;

import cn.com.infosec.asn1.ASN1ObjectIdentifier;
import cn.com.infosec.asn1.x9.ECNamedCurveTable;
import cn.com.infosec.asn1.x9.X962Parameters;
import cn.com.infosec.asn1.x9.X9ECParameters;
import cn.com.infosec.crypto.ec.CustomNamedCurves;
import cn.com.infosec.crypto.params.ECDomainParameters;
import cn.com.infosec.jcajce.provider.asymmetric.util.ECUtil;
import cn.com.infosec.jcajce.provider.config.ProviderConfiguration;
import cn.com.infosec.jce.provider.INFOSECProvider;
import cn.com.infosec.jce.spec.ECNamedCurveParameterSpec;
import cn.com.infosec.jce.spec.ECNamedCurveSpec;
import cn.com.infosec.math.ec.ECAlgorithms;
import cn.com.infosec.math.ec.ECCurve;
import cn.com.infosec.math.field.FiniteField;
import cn.com.infosec.math.field.Polynomial;
import cn.com.infosec.math.field.PolynomialExtensionField;
import cn.com.infosec.util.Arrays;
import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EC5Util {
    private static Map customCurves = new HashMap();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ECCurve getCurve(ProviderConfiguration configuration, X962Parameters params) {
        Set acceptableCurves = configuration.getAcceptableNamedCurves();
        if (params.isNamedCurve()) {
            X9ECParameters ecP;
            ASN1ObjectIdentifier oid = ASN1ObjectIdentifier.getInstance(params.getParameters());
            if (!acceptableCurves.isEmpty()) {
                if (!acceptableCurves.contains(oid)) throw new IllegalStateException("named curve not acceptable");
            }
            if ((ecP = ECUtil.getNamedCurveByOid(oid)) != null) return ecP.getCurve();
            ecP = (X9ECParameters)configuration.getAdditionalECParameters().get(oid);
            return ecP.getCurve();
        }
        if (params.isImplicitlyCA()) {
            return configuration.getEcImplicitlyCa().getCurve();
        }
        if (!acceptableCurves.isEmpty()) throw new IllegalStateException("encoded parameters not acceptable");
        X9ECParameters ecP = X9ECParameters.getInstance(params.getParameters());
        return ecP.getCurve();
    }

    public static ECDomainParameters getDomainParameters(ProviderConfiguration configuration, ECParameterSpec params) {
        ECDomainParameters domainParameters;
        if (params == null) {
            cn.com.infosec.jce.spec.ECParameterSpec iSpec = configuration.getEcImplicitlyCa();
            domainParameters = new ECDomainParameters(iSpec.getCurve(), iSpec.getG(), iSpec.getN(), iSpec.getH(), iSpec.getSeed());
        } else {
            domainParameters = ECUtil.getDomainParameters(configuration, EC5Util.convertSpec(params));
        }
        return domainParameters;
    }

    public static ECParameterSpec convertToSpec(X962Parameters params, ECCurve curve) {
        ECParameterSpec ecSpec;
        if (params.isNamedCurve()) {
            Map additionalECParameters;
            ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)params.getParameters();
            X9ECParameters ecP = ECUtil.getNamedCurveByOid(oid);
            if (ecP == null && !(additionalECParameters = INFOSECProvider.CONFIGURATION.getAdditionalECParameters()).isEmpty()) {
                ecP = (X9ECParameters)additionalECParameters.get(oid);
            }
            EllipticCurve ellipticCurve = EC5Util.convertCurve(curve, ecP.getSeed());
            ecSpec = new ECNamedCurveSpec(ECUtil.getCurveName(oid), ellipticCurve, EC5Util.convertPoint(ecP.getG()), ecP.getN(), ecP.getH());
        } else if (params.isImplicitlyCA()) {
            ecSpec = null;
        } else {
            X9ECParameters ecP = X9ECParameters.getInstance(params.getParameters());
            EllipticCurve ellipticCurve = EC5Util.convertCurve(curve, ecP.getSeed());
            ecSpec = ecP.getH() != null ? new ECParameterSpec(ellipticCurve, EC5Util.convertPoint(ecP.getG()), ecP.getN(), ecP.getH().intValue()) : new ECParameterSpec(ellipticCurve, EC5Util.convertPoint(ecP.getG()), ecP.getN(), 1);
        }
        return ecSpec;
    }

    public static ECParameterSpec convertToSpec(X9ECParameters domainParameters) {
        return new ECParameterSpec(EC5Util.convertCurve(domainParameters.getCurve(), null), EC5Util.convertPoint(domainParameters.getG()), domainParameters.getN(), domainParameters.getH().intValue());
    }

    public static ECParameterSpec convertToSpec(ECDomainParameters domainParameters) {
        return new ECParameterSpec(EC5Util.convertCurve(domainParameters.getCurve(), null), EC5Util.convertPoint(domainParameters.getG()), domainParameters.getN(), domainParameters.getH().intValue());
    }

    public static EllipticCurve convertCurve(ECCurve curve, byte[] seed) {
        ECField field = EC5Util.convertField(curve.getField());
        BigInteger a = curve.getA().toBigInteger();
        BigInteger b = curve.getB().toBigInteger();
        return new EllipticCurve(field, a, b, null);
    }

    public static ECCurve convertCurve(EllipticCurve ec) {
        ECField field = ec.getField();
        BigInteger a = ec.getA();
        BigInteger b = ec.getB();
        if (field instanceof ECFieldFp) {
            ECCurve.Fp curve = new ECCurve.Fp(((ECFieldFp)field).getP(), a, b);
            if (customCurves.containsKey(curve)) {
                return (ECCurve)customCurves.get(curve);
            }
            return curve;
        }
        ECFieldF2m fieldF2m = (ECFieldF2m)field;
        int m = fieldF2m.getM();
        int[] ks = ECUtil.convertMidTerms(fieldF2m.getMidTermsOfReductionPolynomial());
        return new ECCurve.F2m(m, ks[0], ks[1], ks[2], a, b);
    }

    public static ECField convertField(FiniteField field) {
        if (ECAlgorithms.isFpField(field)) {
            return new ECFieldFp(field.getCharacteristic());
        }
        Polynomial poly = ((PolynomialExtensionField)field).getMinimalPolynomial();
        int[] exponents = poly.getExponentsPresent();
        int[] ks = Arrays.reverse(Arrays.copyOfRange(exponents, 1, exponents.length - 1));
        return new ECFieldF2m(poly.getDegree(), ks);
    }

    public static ECParameterSpec convertSpec(EllipticCurve ellipticCurve, cn.com.infosec.jce.spec.ECParameterSpec spec) {
        ECPoint g = EC5Util.convertPoint(spec.getG());
        if (spec instanceof ECNamedCurveParameterSpec) {
            String name = ((ECNamedCurveParameterSpec)spec).getName();
            return new ECNamedCurveSpec(name, ellipticCurve, g, spec.getN(), spec.getH());
        }
        return new ECParameterSpec(ellipticCurve, g, spec.getN(), spec.getH().intValue());
    }

    public static cn.com.infosec.jce.spec.ECParameterSpec convertSpec(ECParameterSpec ecSpec) {
        ECCurve curve = EC5Util.convertCurve(ecSpec.getCurve());
        cn.com.infosec.math.ec.ECPoint g = EC5Util.convertPoint(curve, ecSpec.getGenerator());
        BigInteger n = ecSpec.getOrder();
        BigInteger h = BigInteger.valueOf(ecSpec.getCofactor());
        byte[] seed = ecSpec.getCurve().getSeed();
        if (ecSpec instanceof ECNamedCurveSpec) {
            return new ECNamedCurveParameterSpec(((ECNamedCurveSpec)ecSpec).getName(), curve, g, n, h, seed);
        }
        return new cn.com.infosec.jce.spec.ECParameterSpec(curve, g, n, h, seed);
    }

    public static cn.com.infosec.jce.spec.ECParameterSpec convertSpec(ECParameterSpec ecSpec, boolean withCompression) {
        ECCurve curve = EC5Util.convertCurve(ecSpec.getCurve());
        cn.com.infosec.math.ec.ECPoint g = EC5Util.convertPoint(curve, ecSpec.getGenerator(), withCompression);
        BigInteger n = ecSpec.getOrder();
        BigInteger h = BigInteger.valueOf(ecSpec.getCofactor());
        byte[] seed = ecSpec.getCurve().getSeed();
        if (ecSpec instanceof ECNamedCurveSpec) {
            return new ECNamedCurveParameterSpec(((ECNamedCurveSpec)ecSpec).getName(), curve, g, n, h, seed);
        }
        return new cn.com.infosec.jce.spec.ECParameterSpec(curve, g, n, h, seed);
    }

    public static cn.com.infosec.math.ec.ECPoint convertPoint(ECParameterSpec ecSpec, ECPoint point) {
        return EC5Util.convertPoint(EC5Util.convertCurve(ecSpec.getCurve()), point);
    }

    public static cn.com.infosec.math.ec.ECPoint convertPoint(ECParameterSpec ecSpec, ECPoint point, boolean withCompression) {
        return EC5Util.convertPoint(EC5Util.convertCurve(ecSpec.getCurve()), point, withCompression);
    }

    public static cn.com.infosec.math.ec.ECPoint convertPoint(ECCurve curve, ECPoint point) {
        return curve.createPoint(point.getAffineX(), point.getAffineY());
    }

    public static cn.com.infosec.math.ec.ECPoint convertPoint(ECCurve curve, ECPoint point, boolean withCompression) {
        return curve.createPoint(point.getAffineX(), point.getAffineY(), withCompression);
    }

    public static ECPoint convertPoint(cn.com.infosec.math.ec.ECPoint point) {
        point = point.normalize();
        return new ECPoint(point.getAffineXCoord().toBigInteger(), point.getAffineYCoord().toBigInteger());
    }

    static {
        Enumeration e = CustomNamedCurves.getNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            X9ECParameters curveParams = ECNamedCurveTable.getByName(name);
            if (curveParams == null) continue;
            customCurves.put(curveParams.getCurve(), CustomNamedCurves.getByName(name).getCurve());
        }
        X9ECParameters x9_25519 = CustomNamedCurves.getByName("Curve25519");
        ECCurve c_25519 = x9_25519.getCurve();
        customCurves.put(new ECCurve.Fp(c_25519.getField().getCharacteristic(), c_25519.getA().toBigInteger(), c_25519.getB().toBigInteger(), c_25519.getOrder(), c_25519.getCofactor()), c_25519);
    }
}

