/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jcajce.provider.digest;

import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.crypto.CipherKeyGenerator;
import cn.com.infosec.crypto.digests.MD2Digest;
import cn.com.infosec.crypto.macs.HMac;
import cn.com.infosec.jcajce.provider.config.ConfigurableProvider;
import cn.com.infosec.jcajce.provider.digest.BCMessageDigest;
import cn.com.infosec.jcajce.provider.digest.DigestAlgorithmProvider;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseMac;

public class MD2 {
    private MD2() {
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = MD2.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.MD2", PREFIX + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + PKCSObjectIdentifiers.md2, "MD2");
            this.addHMACAlgorithm(provider, "MD2", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACMD2", 128, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new MD2Digest()));
        }
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new MD2Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new MD2Digest((MD2Digest)this.digest);
            return d;
        }
    }
}

