/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jcajce.provider.digest;

import cn.com.infosec.asn1.iso.ISOIECObjectIdentifiers;
import cn.com.infosec.crypto.CipherKeyGenerator;
import cn.com.infosec.crypto.digests.WhirlpoolDigest;
import cn.com.infosec.crypto.macs.HMac;
import cn.com.infosec.jcajce.provider.config.ConfigurableProvider;
import cn.com.infosec.jcajce.provider.digest.BCMessageDigest;
import cn.com.infosec.jcajce.provider.digest.DigestAlgorithmProvider;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseMac;

public class Whirlpool {
    private Whirlpool() {
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = Whirlpool.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.WHIRLPOOL", PREFIX + "$Digest");
            provider.addAlgorithm("MessageDigest", ISOIECObjectIdentifiers.whirlpool, PREFIX + "$Digest");
            this.addHMACAlgorithm(provider, "WHIRLPOOL", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACWHIRLPOOL", 512, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new WhirlpoolDigest()));
        }
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new WhirlpoolDigest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new WhirlpoolDigest((WhirlpoolDigest)this.digest);
            return d;
        }
    }
}

