/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jcajce.provider.keystore.ckx;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1ObjectIdentifier;
import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.ASN1OutputStream;
import cn.com.infosec.asn1.ASN1Primitive;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1Set;
import cn.com.infosec.asn1.BEROctetString;
import cn.com.infosec.asn1.BEROutputStream;
import cn.com.infosec.asn1.DERBMPString;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.DERSet;
import cn.com.infosec.asn1.gm.EncryptedData;
import cn.com.infosec.asn1.gm.GMObjectIdentifiers;
import cn.com.infosec.asn1.gm.Q5PBESParameters;
import cn.com.infosec.asn1.gm.Q5PBKDFParams;
import cn.com.infosec.asn1.pkcs.AuthenticatedSafe;
import cn.com.infosec.asn1.pkcs.CRLBag;
import cn.com.infosec.asn1.pkcs.CertBag;
import cn.com.infosec.asn1.pkcs.ContentInfo;
import cn.com.infosec.asn1.pkcs.EncryptedPrivateKeyInfo;
import cn.com.infosec.asn1.pkcs.EncryptionScheme;
import cn.com.infosec.asn1.pkcs.KeyDerivationFunc;
import cn.com.infosec.asn1.pkcs.MacData;
import cn.com.infosec.asn1.pkcs.PKCS12PBEParams;
import cn.com.infosec.asn1.pkcs.PrivateKeyInfo;
import cn.com.infosec.asn1.pkcs.SafeBag;
import cn.com.infosec.asn1.util.ASN1Dump;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.AuthorityKeyIdentifier;
import cn.com.infosec.asn1.x509.DigestInfo;
import cn.com.infosec.asn1.x509.Extension;
import cn.com.infosec.asn1.x509.SubjectKeyIdentifier;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.asn1.x509.X509ObjectIdentifiers;
import cn.com.infosec.crypto.digests.SM3Digest;
import cn.com.infosec.jcajce.PKCS12Key;
import cn.com.infosec.jcajce.provider.keystore.ckx.Ckx;
import cn.com.infosec.jcajce.provider.keystore.ckx.CkxUtil;
import cn.com.infosec.jcajce.provider.keystore.ckx.DuoPair;
import cn.com.infosec.jcajce.provider.keystore.ckx.GMPKCS8EncryptorBuilder;
import cn.com.infosec.jcajce.spec.PBKDF2KeySpec;
import cn.com.infosec.jcajce.util.InfosecJcaJceHelper;
import cn.com.infosec.jcajce.util.JcaJceHelper;
import cn.com.infosec.jce.interfaces.BCKeyStore;
import cn.com.infosec.jce.interfaces.PKCS12BagAttributeCarrier;
import cn.com.infosec.jce.provider.INFOSECProvider;
import cn.com.infosec.operator.pkcs8.PKCS8EncryptedPrivateKeyInfo;
import cn.com.infosec.operator.pkcs8.PKCS8EncryptedPrivateKeyInfoBuilder;
import cn.com.infosec.util.Arrays;
import cn.com.infosec.util.Integers;
import cn.com.infosec.util.Properties;
import cn.com.infosec.util.Strings;
import cn.com.infosec.util.encoders.Hex;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class CKXKeyStore
extends KeyStoreSpi
implements GMObjectIdentifiers,
X509ObjectIdentifiers,
BCKeyStore {
    static final String CKX_MAX_IT_COUNT_PROPERTY = "max_it_count";
    private final JcaJceHelper helper = new InfosecJcaJceHelper();
    private static final int SALT_SIZE = 20;
    private static final int MIN_ITERATIONS = 1024;
    private static final DefaultSecretKeyProvider keySizeProvider = new DefaultSecretKeyProvider();
    private IgnoresCaseHashtable keys = new IgnoresCaseHashtable();
    private Hashtable localIds = new Hashtable();
    private IgnoresCaseHashtable certs = new IgnoresCaseHashtable();
    private Hashtable chainCerts = new Hashtable();
    private Hashtable keyCerts = new Hashtable();
    private IgnoresCaseHashtable crls = new IgnoresCaseHashtable();
    protected SecureRandom random = new SecureRandom();
    private CertificateFactory certFact;
    private ASN1ObjectIdentifier algorithm;
    private final PublicKey publicKey;
    private List<DuoPair> duoList = new ArrayList<DuoPair>();
    private IgnoresCaseHashtable duoKeys = new IgnoresCaseHashtable();
    private IgnoresCaseHashtable duoCerts = new IgnoresCaseHashtable();
    private static AlgorithmIdentifier macAlgorithm = new AlgorithmIdentifier(hmac_sm3);
    private int itCount = 2048;
    private int saltLength = 20;
    private Provider provider = null;

    public CKXKeyStore() {
        this(id_PBES, null);
    }

    public CKXKeyStore(PublicKey publicKey) {
        this(id_PBES, publicKey);
    }

    private CKXKeyStore(ASN1ObjectIdentifier algorithm, PublicKey publicKey) {
        this.getBouncyCastleProvider();
        this.algorithm = algorithm;
        this.publicKey = publicKey;
        try {
            this.certFact = this.provider != null ? CertificateFactory.getInstance("X.509", this.provider) : CertificateFactory.getInstance("X.509");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't create cert factory - " + e.toString());
        }
    }

    private SubjectKeyIdentifier createSubjectKeyId(PublicKey pubKey) {
        try {
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance(pubKey.getEncoded());
            return new SubjectKeyIdentifier(CKXKeyStore.getDigest(info));
        }
        catch (Exception e) {
            throw new RuntimeException("error creating key");
        }
    }

    private static byte[] getDigest(SubjectPublicKeyInfo spki) {
        SM3Digest digest = new SM3Digest();
        byte[] resBuf = new byte[digest.getDigestSize()];
        byte[] bytes = spki.getPublicKeyData().getBytes();
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(resBuf, 0);
        return resBuf;
    }

    @Override
    public void setRandom(SecureRandom rand) {
        this.random = rand;
    }

    public Enumeration engineAliases() {
        Hashtable<Object, String> tab = new Hashtable<Object, String>();
        Enumeration e = this.certs.keys();
        while (e.hasMoreElements()) {
            tab.put(e.nextElement(), "cert");
        }
        e = this.keys.keys();
        while (e.hasMoreElements()) {
            String a = (String)e.nextElement();
            if (tab.get(a) != null) continue;
            tab.put(a, "key");
        }
        return tab.keys();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.certs.get(alias) != null || this.keys.get(alias) != null;
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        Key k = (Key)this.keys.remove(alias);
        Certificate c = (Certificate)this.certs.remove(alias);
        if (c != null) {
            this.chainCerts.remove(new CertId(c.getPublicKey()));
        }
        if (k != null) {
            String id = (String)this.localIds.remove(alias);
            if (id != null) {
                c = (Certificate)this.keyCerts.remove(id);
            }
            if (c != null) {
                this.chainCerts.remove(new CertId(c.getPublicKey()));
            }
        }
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("null alias passed to getCertificate.");
        }
        Certificate c = (Certificate)this.certs.get(alias);
        if (c == null) {
            String id = (String)this.localIds.get(alias);
            c = id != null ? (Certificate)this.keyCerts.get(id) : (Certificate)this.keyCerts.get(alias);
        }
        return c;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        String ta;
        Certificate tc;
        Enumeration c = this.certs.elements();
        Enumeration k = this.certs.keys();
        while (c.hasMoreElements()) {
            tc = (Certificate)c.nextElement();
            ta = (String)k.nextElement();
            if (!tc.equals(cert)) continue;
            return ta;
        }
        c = this.keyCerts.elements();
        k = this.keyCerts.keys();
        while (c.hasMoreElements()) {
            tc = (Certificate)c.nextElement();
            ta = (String)k.nextElement();
            if (!tc.equals(cert)) continue;
            return ta;
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("null alias passed to getCertificateChain.");
        }
        if (!this.engineIsKeyEntry(alias)) {
            return null;
        }
        Certificate c = this.engineGetCertificate(alias);
        if (c != null) {
            Vector<Certificate> cs = new Vector<Certificate>();
            while (c != null) {
                Principal s;
                Principal i;
                X509Certificate x509c = (X509Certificate)c;
                Certificate nextC = null;
                byte[] bytes = x509c.getExtensionValue(Extension.authorityKeyIdentifier.getId());
                if (bytes != null) {
                    try {
                        ASN1InputStream aIn = new ASN1InputStream(bytes);
                        byte[] authBytes = ((ASN1OctetString)aIn.readObject()).getOctets();
                        aIn = new ASN1InputStream(authBytes);
                        AuthorityKeyIdentifier id = AuthorityKeyIdentifier.getInstance(aIn.readObject());
                        if (id.getKeyIdentifier() != null) {
                            nextC = (Certificate)this.chainCerts.get(new CertId(id.getKeyIdentifier()));
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e.toString());
                    }
                }
                if (nextC == null && !((Object)(i = x509c.getIssuerDN())).equals(s = x509c.getSubjectDN())) {
                    Enumeration e = this.chainCerts.keys();
                    while (e.hasMoreElements()) {
                        X509Certificate crt = (X509Certificate)this.chainCerts.get(e.nextElement());
                        Principal sub = crt.getSubjectDN();
                        if (!((Object)sub).equals(i)) continue;
                        try {
                            x509c.verify(crt.getPublicKey());
                            nextC = crt;
                            break;
                        }
                        catch (Exception ex) {
                        }
                    }
                }
                if (cs.contains(c)) {
                    c = null;
                    continue;
                }
                cs.addElement(c);
                if (nextC != c) {
                    c = nextC;
                    continue;
                }
                c = null;
            }
            Certificate[] certChain = new Certificate[cs.size()];
            for (int i = 0; i != certChain.length; ++i) {
                certChain[i] = (Certificate)cs.elementAt(i);
            }
            return certChain;
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        if (this.keys.get(alias) == null && this.certs.get(alias) == null) {
            return null;
        }
        return new Date();
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (alias == null) {
            throw new IllegalArgumentException("null alias passed to getKey.");
        }
        return (Key)this.keys.get(alias);
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return this.certs.get(alias) != null && this.keys.get(alias) == null;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return this.keys.get(alias) != null;
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        if (this.keys.get(alias) != null) {
            throw new KeyStoreException("There is a key entry with the name " + alias + ".");
        }
        this.certs.put(alias, cert);
        this.chainCerts.put(new CertId(cert.getPublicKey()), cert);
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new RuntimeException("operation not supported");
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (!(key instanceof PrivateKey)) {
            throw new KeyStoreException("CKX does not support non-PrivateKeys");
        }
        if (key instanceof PrivateKey && chain == null) {
            throw new KeyStoreException("no certificate chain for private key");
        }
        if (this.keys.get(alias) != null) {
            this.engineDeleteEntry(alias);
        }
        this.keys.put(alias, key);
        if (chain != null) {
            this.certs.put(alias, chain[0]);
            for (int i = 0; i != chain.length; ++i) {
                this.chainCerts.put(new CertId(chain[i].getPublicKey()), chain[i]);
            }
        }
    }

    @Override
    public int engineSize() {
        HashMap<Object, String> tab = new HashMap<Object, String>();
        Enumeration e = this.certs.keys();
        while (e.hasMoreElements()) {
            tab.put(e.nextElement(), "cert");
        }
        e = this.keys.keys();
        while (e.hasMoreElements()) {
            String a = (String)e.nextElement();
            String v = (String)tab.get(a);
            if (v != null) continue;
            tab.put(a, "key");
        }
        return tab.size();
    }

    protected PrivateKey unwrapKey(AlgorithmIdentifier algId, byte[] data, char[] password) throws IOException {
        ASN1ObjectIdentifier algorithm = algId.getAlgorithm();
        try {
            if (algorithm.equals(id_PBES)) {
                Cipher cipher = this.createCipher(4, password, algId);
                return (PrivateKey)cipher.unwrap(data, "", 2);
            }
        }
        catch (Exception e) {
            throw new IOException("exception unwrapping private key - " + e.toString());
        }
        throw new IOException("exception unwrapping private key - cannot recognise: " + algorithm);
    }

    protected byte[] wrapKey(Key key, AlgorithmIdentifier algId, char[] password) throws IOException {
        byte[] out = null;
        PKCS8EncryptedPrivateKeyInfoBuilder builder = new PKCS8EncryptedPrivateKeyInfoBuilder(key.getEncoded());
        try {
            PKCS8EncryptedPrivateKeyInfo info = builder.build(new GMPKCS8EncryptorBuilder(algId).setPassword(password).build());
            out = info.getEncoded();
        }
        catch (Exception e) {
            // empty catch block
        }
        return out;
    }

    protected byte[] cryptData(boolean forEncryption, AlgorithmIdentifier algId, char[] password, byte[] data) throws IOException {
        int mode;
        ASN1ObjectIdentifier algorithm = algId.getAlgorithm();
        int n = mode = forEncryption ? 1 : 2;
        if (algorithm.equals(id_PBES)) {
            try {
                Cipher cipher = this.createCipher(mode, password, algId);
                return cipher.doFinal(data);
            }
            catch (Exception e) {
                throw new IOException("exception decrypting data - " + e.toString());
            }
        }
        throw new IOException("unknown PBE algorithm: " + algorithm);
    }

    public Cipher createCipher(int mode, char[] password, AlgorithmIdentifier algId) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchProviderException {
        Q5PBESParameters alg = Q5PBESParameters.getInstance(algId.getParameters());
        Q5PBKDFParams func = Q5PBKDFParams.getInstance(alg.getKeyDerivationFunc().getParameters());
        AlgorithmIdentifier encScheme = AlgorithmIdentifier.getInstance(alg.getEncryptionScheme());
        SecretKeyFactory keyFact = this.helper.createSecretKeyFactory(alg.getKeyDerivationFunc().getAlgorithm().getId());
        SecretKey key = keyFact.generateSecret(new PBKDF2KeySpec(password, func.getSalt(), this.validateIterationCount(func.getIterationCount()), keySizeProvider.getKeySize(encScheme), func.getPrf()));
        Cipher cipher = Cipher.getInstance(alg.getEncryptionScheme().getAlgorithm().getId());
        ASN1Encodable encParams = alg.getEncryptionScheme().getParameters();
        if (!(encParams instanceof ASN1OctetString)) {
            throw new InvalidAlgorithmParameterException("can't finding this Parameter" + encParams.getClass());
        }
        cipher.init(mode, (Key)key, new IvParameterSpec(ASN1OctetString.getInstance(encParams).getOctets()));
        return cipher;
    }

    public void addDuoCertPair(DuoPair pair) {
        this.duoList.add(pair);
    }

    public void setDuoCertPair(List<DuoPair> pair) {
        this.duoList = pair;
    }

    public Certificate getDuoCertificate(String alias) {
        return (Certificate)this.duoCerts.get(alias);
    }

    public PrivateKey getDuoKey(String alias) {
        return (PrivateKey)this.duoKeys.get(alias);
    }

    public Map<String, String> getDuoAlias() {
        HashMap<String, String> tab = new HashMap<String, String>();
        Enumeration e = this.duoCerts.keys();
        while (e.hasMoreElements()) {
            tab.put((String)e.nextElement(), "cert");
        }
        e = this.duoKeys.keys();
        while (e.hasMoreElements()) {
            String a = (String)e.nextElement();
            String v = (String)tab.get(a);
            if (v != null) continue;
            tab.put(a, "key");
        }
        return tab;
    }

    @Deprecated
    public List<DuoPair> getDuoCertPair() {
        return null;
    }

    public void addSingleCertPair(PrivateKey priKey, Certificate cert, String alias) throws KeyException {
        if (!CkxUtil.keyMatch(priKey, cert.getPublicKey())) {
            throw new KeyException("certificate not matches private key\n" + cert.toString());
        }
        if (alias == null) {
            alias = UUID.randomUUID().toString();
        }
        this.keys.put(alias, priKey);
        this.certs.put(alias, cert);
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException {
        if (stream == null) {
            return;
        }
        if (password == null) {
            throw new NullPointerException("No password supplied for CKX KeyStore.");
        }
        BufferedInputStream bufIn = new BufferedInputStream(stream);
        bufIn.mark(10);
        int head = bufIn.read();
        if (head != 48) {
            throw new IOException("stream does not represent a CKX key store");
        }
        bufIn.reset();
        ASN1InputStream bIn = new ASN1InputStream(bufIn);
        ASN1Sequence obj = (ASN1Sequence)bIn.readObject();
        Ckx bag = Ckx.getInstance(obj);
        ContentInfo info = bag.getAuthSafe();
        Vector<SafeBag> chain = new Vector<SafeBag>();
        boolean unmarkedKey = false;
        boolean unmarkedCrl = false;
        if (bag.getMacData() != null) {
            MacData mData = bag.getMacData();
            DigestInfo dInfo = mData.getMac();
            macAlgorithm = dInfo.getAlgorithmId();
            byte[] salt = mData.getSalt();
            this.itCount = this.validateIterationCount(mData.getIterationCount());
            this.saltLength = salt.length;
            byte[] data = ((ASN1OctetString)info.getContent()).getOctets();
            try {
                byte[] res = this.calculateHMac(macAlgorithm.getAlgorithm(), salt, this.itCount, password, data);
                byte[] dig = dInfo.getDigest();
                if (!Arrays.constantTimeAreEqual(res, dig)) {
                    if (password.length > 0) {
                        throw new IOException("CKX key store mac invalid - wrong password or corrupted file.");
                    }
                    res = this.calculateHMac(macAlgorithm.getAlgorithm(), salt, this.itCount, password, data);
                    if (!Arrays.constantTimeAreEqual(res, dig)) {
                        throw new IOException("CKX key store mac invalid - wrong password or corrupted file.");
                    }
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("error constructing MAC: " + e.toString());
            }
        }
        this.keys = new IgnoresCaseHashtable();
        this.localIds = new Hashtable();
        if (info.getContentType().equals(data)) {
            bIn = new ASN1InputStream(((ASN1OctetString)info.getContent()).getOctets());
            AuthenticatedSafe authSafe = AuthenticatedSafe.getInstance(bIn.readObject());
            ContentInfo[] c = authSafe.getContentInfo();
            for (int i = 0; i != c.length; ++i) {
                if (c[i].getContentType().equals(data)) {
                    ASN1InputStream dIn = new ASN1InputStream(((ASN1OctetString)c[i].getContent()).getOctets());
                    ASN1Sequence seq = (ASN1Sequence)dIn.readObject();
                    for (int j = 0; j != seq.size(); ++j) {
                        String name;
                        ASN1Encodable existing;
                        PKCS12BagAttributeCarrier bagAttr;
                        ASN1Primitive attr;
                        ASN1Set attrSet;
                        ASN1ObjectIdentifier aOid;
                        ASN1Sequence sq;
                        Enumeration e;
                        SafeBag b = SafeBag.getInstance(seq.getObjectAt(j));
                        if (b.getBagId().equals(ckx_shroudedKeyBag)) {
                            EncryptedPrivateKeyInfo eIn = EncryptedPrivateKeyInfo.getInstance(b.getBagValue());
                            PrivateKey privKey = this.unwrapKey(eIn.getEncryptionAlgorithm(), eIn.getEncryptedData(), password);
                            String alias = null;
                            ASN1OctetString localId = null;
                            if (b.getBagAttributes() != null) {
                                e = b.getBagAttributes().getObjects();
                                while (e.hasMoreElements()) {
                                    sq = (ASN1Sequence)e.nextElement();
                                    aOid = (ASN1ObjectIdentifier)sq.getObjectAt(0);
                                    attrSet = (ASN1Set)sq.getObjectAt(1);
                                    attr = null;
                                    if (attrSet.size() > 0) {
                                        attr = (ASN1Primitive)attrSet.getObjectAt(0);
                                        if (privKey instanceof PKCS12BagAttributeCarrier) {
                                            bagAttr = (PKCS12BagAttributeCarrier)((Object)privKey);
                                            existing = bagAttr.getBagAttribute(aOid);
                                            if (existing != null) {
                                                if (!existing.toASN1Primitive().equals(attr)) {
                                                    throw new IOException("attempt to add existing attribute with different value");
                                                }
                                            } else {
                                                bagAttr.setBagAttribute(aOid, attr);
                                            }
                                        }
                                    }
                                    if (aOid.equals(pkcs9_friendlyName)) {
                                        alias = ((DERBMPString)attr).getString();
                                        this.keys.put(alias, privKey);
                                        continue;
                                    }
                                    if (!aOid.equals(pkcs9_localKeyId)) continue;
                                    localId = (ASN1OctetString)attr;
                                }
                            }
                            if (localId != null) {
                                name = new String(Hex.encode(localId.getOctets()));
                                if (alias == null) {
                                    this.keys.put(name, privKey);
                                    continue;
                                }
                                this.localIds.put(alias, name);
                                continue;
                            }
                            unmarkedKey = true;
                            this.keys.put("unmarked", privKey);
                            continue;
                        }
                        if (b.getBagId().equals(ckx_certBag)) {
                            chain.addElement(b);
                            continue;
                        }
                        if (!b.getBagId().equals(ckx_crlBag)) continue;
                        CRLBag crlB = CRLBag.getInstance(b.getBagValue());
                        X509CRL crlx509 = null;
                        try {
                            ByteArrayInputStream crlIn = new ByteArrayInputStream(((ASN1OctetString)crlB.getCrlValue()).getOctets());
                            crlx509 = (X509CRL)this.certFact.generateCRL(crlIn);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        ASN1OctetString localId = null;
                        String alias = null;
                        if (b.getBagAttributes() != null) {
                            e = b.getBagAttributes().getObjects();
                            while (e.hasMoreElements()) {
                                sq = (ASN1Sequence)e.nextElement();
                                aOid = (ASN1ObjectIdentifier)sq.getObjectAt(0);
                                attrSet = (ASN1Set)sq.getObjectAt(1);
                                if (attrSet.size() <= 0) continue;
                                attr = (ASN1Primitive)attrSet.getObjectAt(0);
                                if (crlx509 instanceof PKCS12BagAttributeCarrier) {
                                    bagAttr = (PKCS12BagAttributeCarrier)((Object)crlx509);
                                    existing = bagAttr.getBagAttribute(aOid);
                                    if (existing != null) {
                                        if (!existing.toASN1Primitive().equals(attr)) {
                                            throw new IOException("attempt to add existing attribute with different value");
                                        }
                                    } else {
                                        bagAttr.setBagAttribute(aOid, attr);
                                    }
                                }
                                if (aOid.equals(pkcs9_friendlyName)) {
                                    alias = ((DERBMPString)attr).getString();
                                    this.crls.put(alias, crlx509);
                                    continue;
                                }
                                if (!aOid.equals(pkcs9_localKeyId)) continue;
                                localId = (ASN1OctetString)attr;
                            }
                        }
                        if (localId != null) {
                            name = new String(Hex.encode(localId.getOctets()));
                            if (alias == null) {
                                this.crls.put(name, crlx509);
                                continue;
                            }
                            this.localIds.put(alias, name);
                            continue;
                        }
                        unmarkedCrl = true;
                        this.crls.put("unmarked", crlx509);
                    }
                    continue;
                }
                if (c[i].getContentType().equals(encryptedData)) {
                    EncryptedData d = EncryptedData.getInstance(c[i].getContent());
                    byte[] octets = this.cryptData(false, d.getEncryptionAlgorithm(), password, d.getContent().getOctets());
                    ASN1Sequence seq = (ASN1Sequence)ASN1Primitive.fromByteArray(octets);
                    for (int j = 0; j != seq.size(); ++j) {
                        boolean isDuo = this.isDuoSequence(seq.getObjectAt(j));
                        if (isDuo) {
                            ASN1Sequence duoSeq = ASN1Sequence.getInstance(seq.getObjectAt(j));
                            for (int k = 0; k < duoSeq.size(); ++k) {
                                SafeBag b = SafeBag.getInstance(duoSeq.getObjectAt(k));
                                if (!b.getBagId().equals(ckx_safeContentBag)) continue;
                                ASN1Sequence sequence = ASN1Sequence.getInstance(b.getBagValue());
                                DuoPair duoPair = new DuoPair();
                                boolean doVerify = false;
                                if (sequence.size() == 2) {
                                    doVerify = true;
                                }
                                Enumeration outsideSeq = sequence.getObjects();
                                while (outsideSeq.hasMoreElements()) {
                                    ASN1Encodable existing;
                                    ASN1Primitive attr;
                                    ASN1Set attrSet;
                                    ASN1ObjectIdentifier aOid;
                                    ASN1Sequence sq;
                                    Enumeration e;
                                    ASN1OctetString localId;
                                    String alias;
                                    PKCS12BagAttributeCarrier bagAttr;
                                    SafeBag safeBag = SafeBag.getInstance(outsideSeq.nextElement());
                                    if (safeBag.getBagId().equals(ckx_shroudedKeyBag)) {
                                        EncryptedPrivateKeyInfo eIn = EncryptedPrivateKeyInfo.getInstance(safeBag.getBagValue());
                                        PrivateKey privKey = this.unwrapKey(eIn.getEncryptionAlgorithm(), eIn.getEncryptedData(), password);
                                        if (doVerify) {
                                            duoPair.setSignKey(privKey);
                                        }
                                        bagAttr = (PKCS12BagAttributeCarrier)((Object)privKey);
                                        alias = null;
                                        localId = null;
                                        if (safeBag.getBagAttributes() == null) continue;
                                        e = safeBag.getBagAttributes().getObjects();
                                        while (e.hasMoreElements()) {
                                            sq = (ASN1Sequence)e.nextElement();
                                            aOid = (ASN1ObjectIdentifier)sq.getObjectAt(0);
                                            attrSet = (ASN1Set)sq.getObjectAt(1);
                                            attr = null;
                                            if (attrSet.size() > 0) {
                                                attr = (ASN1Primitive)attrSet.getObjectAt(0);
                                                existing = bagAttr.getBagAttribute(aOid);
                                                if (existing != null) {
                                                    if (!existing.toASN1Primitive().equals(attr)) {
                                                        throw new IOException("attempt to add existing attribute with different value");
                                                    }
                                                } else {
                                                    bagAttr.setBagAttribute(aOid, attr);
                                                }
                                            }
                                            if (aOid.equals(pkcs9_friendlyName)) {
                                                alias = ((DERBMPString)attr).getString();
                                                this.duoKeys.put(alias, privKey);
                                                continue;
                                            }
                                            if (!aOid.equals(pkcs9_localKeyId)) continue;
                                            localId = (ASN1OctetString)attr;
                                        }
                                        continue;
                                    }
                                    if (safeBag.getBagId().equals(ckx_certBag)) {
                                        Certificate cert;
                                        CertBag cb = CertBag.getInstance(safeBag.getBagValue());
                                        if (!cb.getCertId().equals(x509Certificate)) {
                                            throw new RuntimeException("Unsupported certificate type: " + cb.getCertId());
                                        }
                                        try {
                                            ByteArrayInputStream cIn = new ByteArrayInputStream(((ASN1OctetString)cb.getCertValue()).getOctets());
                                            cert = this.certFact.generateCertificate(cIn);
                                        }
                                        catch (Exception e3) {
                                            throw new RuntimeException(e3.toString());
                                        }
                                        if (doVerify) {
                                            duoPair.setSignCert(cert);
                                        }
                                        bagAttr = (PKCS12BagAttributeCarrier)((Object)cert);
                                        alias = null;
                                        localId = null;
                                        if (safeBag.getBagAttributes() == null) continue;
                                        e = safeBag.getBagAttributes().getObjects();
                                        while (e.hasMoreElements()) {
                                            sq = (ASN1Sequence)e.nextElement();
                                            aOid = (ASN1ObjectIdentifier)sq.getObjectAt(0);
                                            attrSet = (ASN1Set)sq.getObjectAt(1);
                                            attr = null;
                                            if (attrSet.size() > 0) {
                                                attr = (ASN1Primitive)attrSet.getObjectAt(0);
                                                existing = bagAttr.getBagAttribute(aOid);
                                                if (existing != null) {
                                                    if (!existing.toASN1Primitive().equals(attr)) {
                                                        throw new IOException("attempt to add existing attribute with different value");
                                                    }
                                                } else {
                                                    bagAttr.setBagAttribute(aOid, attr);
                                                }
                                            }
                                            if (aOid.equals(pkcs9_friendlyName)) {
                                                alias = ((DERBMPString)attr).getString();
                                                this.duoCerts.put(alias, cert);
                                                continue;
                                            }
                                            if (!aOid.equals(pkcs9_localKeyId)) continue;
                                            localId = (ASN1OctetString)attr;
                                        }
                                        continue;
                                    }
                                    System.out.println("extra " + c[i].getContentType().getId());
                                    System.out.println("extra " + ASN1Dump.dumpAsString(c[i].getContent()));
                                }
                                if (!doVerify) continue;
                                boolean match = CkxUtil.keyMatch(duoPair.getSignKey(), duoPair.getSignCert().getPublicKey());
                            }
                            continue;
                        }
                        this.parserSafeBag(password, chain, seq.getObjectAt(j));
                    }
                    continue;
                }
                System.out.println("extra " + c[i].getContentType().getId());
                System.out.println("extra " + ASN1Dump.dumpAsString(c[i].getContent()));
            }
        }
        this.certs = new IgnoresCaseHashtable();
        this.chainCerts = new Hashtable();
        this.keyCerts = new Hashtable();
        for (int i = 0; i != chain.size(); ++i) {
            String name;
            Certificate cert;
            SafeBag b = (SafeBag)chain.elementAt(i);
            CertBag cb = CertBag.getInstance(b.getBagValue());
            if (!cb.getCertId().equals(x509Certificate)) {
                throw new RuntimeException("Unsupported certificate type: " + cb.getCertId());
            }
            try {
                ByteArrayInputStream cIn = new ByteArrayInputStream(((ASN1OctetString)cb.getCertValue()).getOctets());
                cert = this.certFact.generateCertificate(cIn);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
            ASN1OctetString localId = null;
            String alias = null;
            if (b.getBagAttributes() != null) {
                Enumeration e = b.getBagAttributes().getObjects();
                while (e.hasMoreElements()) {
                    ASN1Sequence sq = ASN1Sequence.getInstance(e.nextElement());
                    ASN1ObjectIdentifier oid = ASN1ObjectIdentifier.getInstance(sq.getObjectAt(0));
                    ASN1Set attrSet = ASN1Set.getInstance(sq.getObjectAt(1));
                    if (attrSet.size() <= 0) continue;
                    ASN1Primitive attr = (ASN1Primitive)attrSet.getObjectAt(0);
                    PKCS12BagAttributeCarrier bagAttr = null;
                    if (cert instanceof PKCS12BagAttributeCarrier) {
                        bagAttr = (PKCS12BagAttributeCarrier)((Object)cert);
                        ASN1Encodable existing = bagAttr.getBagAttribute(oid);
                        if (existing != null) {
                            if (!existing.toASN1Primitive().equals(attr)) {
                                throw new IOException("attempt to add existing attribute with different value");
                            }
                        } else {
                            bagAttr.setBagAttribute(oid, attr);
                        }
                    }
                    if (oid.equals(pkcs9_friendlyName)) {
                        alias = ((DERBMPString)attr).getString();
                        continue;
                    }
                    if (!oid.equals(pkcs9_localKeyId)) continue;
                    localId = (ASN1OctetString)attr;
                }
            }
            this.chainCerts.put(new CertId(cert.getPublicKey()), cert);
            if (unmarkedKey) {
                if (!this.keyCerts.isEmpty()) continue;
                name = new String(Hex.encode(this.createSubjectKeyId(cert.getPublicKey()).getKeyIdentifier()));
                this.keyCerts.put(name, cert);
                this.keys.put(name, this.keys.remove("unmarked"));
                continue;
            }
            if (unmarkedCrl) {
                name = new String(Hex.encode(this.createSubjectKeyId(cert.getPublicKey()).getKeyIdentifier()));
                this.crls.put(name, this.crls.remove("unmarked"));
                continue;
            }
            if (localId != null) {
                name = new String(Hex.encode(localId.getOctets()));
                this.keyCerts.put(name, cert);
            }
            if (alias == null) continue;
            this.certs.put(alias, cert);
        }
    }

    private void parserSafeBag(char[] password, Vector chain, ASN1Encodable seq) throws IOException {
        SafeBag b = SafeBag.getInstance(seq);
        if (b.getBagId().equals(ckx_certBag)) {
            chain.addElement(b);
        } else if (b.getBagId().equals(ckx_shroudedKeyBag)) {
            EncryptedPrivateKeyInfo eIn = EncryptedPrivateKeyInfo.getInstance(b.getBagValue());
            PrivateKey privKey = this.unwrapKey(eIn.getEncryptionAlgorithm(), eIn.getEncryptedData(), password);
            PKCS12BagAttributeCarrier bagAttr = (PKCS12BagAttributeCarrier)((Object)privKey);
            String alias = null;
            ASN1OctetString localId = null;
            Enumeration e = b.getBagAttributes().getObjects();
            while (e.hasMoreElements()) {
                ASN1Sequence sq = (ASN1Sequence)e.nextElement();
                ASN1ObjectIdentifier aOid = (ASN1ObjectIdentifier)sq.getObjectAt(0);
                ASN1Set attrSet = (ASN1Set)sq.getObjectAt(1);
                ASN1Primitive attr = null;
                if (attrSet.size() > 0) {
                    attr = (ASN1Primitive)attrSet.getObjectAt(0);
                    ASN1Encodable existing = bagAttr.getBagAttribute(aOid);
                    if (existing != null) {
                        if (!existing.toASN1Primitive().equals(attr)) {
                            throw new IOException("attempt to add existing attribute with different value");
                        }
                    } else {
                        bagAttr.setBagAttribute(aOid, attr);
                    }
                }
                if (aOid.equals(pkcs9_friendlyName)) {
                    alias = ((DERBMPString)attr).getString();
                    this.keys.put(alias, privKey);
                    continue;
                }
                if (!aOid.equals(pkcs9_localKeyId)) continue;
                localId = (ASN1OctetString)attr;
            }
            String name = new String(Hex.encode(localId.getOctets()));
            if (alias == null) {
                this.keys.put(name, privKey);
            } else {
                this.localIds.put(alias, name);
            }
        } else if (b.getBagId().equals(ckx_keyBag)) {
            PrivateKeyInfo kInfo = PrivateKeyInfo.getInstance(b.getBagValue());
            PrivateKey privKey = INFOSECProvider.getPrivateKey(kInfo);
            PKCS12BagAttributeCarrier bagAttr = (PKCS12BagAttributeCarrier)((Object)privKey);
            String alias = null;
            ASN1OctetString localId = null;
            Enumeration e = b.getBagAttributes().getObjects();
            while (e.hasMoreElements()) {
                ASN1Sequence sq = ASN1Sequence.getInstance(e.nextElement());
                ASN1ObjectIdentifier aOid = ASN1ObjectIdentifier.getInstance(sq.getObjectAt(0));
                ASN1Set attrSet = ASN1Set.getInstance(sq.getObjectAt(1));
                ASN1Primitive attr = null;
                if (attrSet.size() <= 0) continue;
                attr = (ASN1Primitive)attrSet.getObjectAt(0);
                ASN1Encodable existing = bagAttr.getBagAttribute(aOid);
                if (existing != null) {
                    if (!existing.toASN1Primitive().equals(attr)) {
                        throw new IOException("attempt to add existing attribute with different value");
                    }
                } else {
                    bagAttr.setBagAttribute(aOid, attr);
                }
                if (aOid.equals(pkcs9_friendlyName)) {
                    alias = ((DERBMPString)attr).getString();
                    this.keys.put(alias, privKey);
                    continue;
                }
                if (!aOid.equals(pkcs9_localKeyId)) continue;
                localId = (ASN1OctetString)attr;
            }
            String name = new String(Hex.encode(localId.getOctets()));
            if (alias == null) {
                this.keys.put(name, privKey);
            } else {
                this.localIds.put(alias, name);
            }
        } else {
            System.out.println("extra in encryptedData " + b.getBagId());
            System.out.println(ASN1Dump.dumpAsString(b));
        }
    }

    private boolean isDuoSequence(ASN1Encodable seq) {
        try {
            SafeBag.getInstance(seq);
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    private int validateIterationCount(BigInteger i) {
        int count = i.intValue();
        if (count < 0) {
            throw new IllegalStateException("negative iteration count found");
        }
        BigInteger maxValue = Properties.asBigInteger(CKX_MAX_IT_COUNT_PROPERTY);
        if (maxValue != null && maxValue.intValue() < count) {
            throw new IllegalStateException("iteration count " + count + " greater than " + maxValue.intValue());
        }
        return count;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException {
        this.doStore(stream, password, false);
    }

    private void doStore(OutputStream stream, char[] password, boolean useDEREncoding) throws IOException {
        MacData mData;
        SafeBag sBag;
        ASN1EncodableVector fSeq;
        ASN1EncodableVector fSeq2;
        ASN1ObjectIdentifier oid;
        Enumeration e;
        DERBMPString nm;
        PKCS12BagAttributeCarrier bagAttrs;
        ASN1EncodableVector fName;
        CertBag cBag;
        boolean cAttrSet;
        Certificate cert;
        ASN1ObjectIdentifier oid2;
        Enumeration e2;
        if (password == null) {
            throw new NullPointerException("No password supplied for CKX KeyStore.");
        }
        Q5PBESParameters pbesParams = this.createPBESParameters();
        AlgorithmIdentifier algId = new AlgorithmIdentifier(this.algorithm, pbesParams.toASN1Primitive());
        ASN1EncodableVector keyS = new ASN1EncodableVector();
        Enumeration ks = this.keys.keys();
        while (ks.hasMoreElements()) {
            String name = (String)ks.nextElement();
            PrivateKey privKey = (PrivateKey)this.keys.get(name);
            byte[] wrapKey = this.wrapKey(privKey, algId, password);
            boolean attrSet = false;
            ASN1EncodableVector kName = new ASN1EncodableVector();
            if (privKey instanceof PKCS12BagAttributeCarrier) {
                PKCS12BagAttributeCarrier bagAttrs2 = (PKCS12BagAttributeCarrier)((Object)privKey);
                DERBMPString nm2 = (DERBMPString)bagAttrs2.getBagAttribute(pkcs9_friendlyName);
                if (nm2 == null || !nm2.getString().equals(name)) {
                    bagAttrs2.setBagAttribute(pkcs9_friendlyName, new DERBMPString(name));
                }
                if (bagAttrs2.getBagAttribute(pkcs9_localKeyId) == null) {
                    Certificate ct = this.engineGetCertificate(name);
                    bagAttrs2.setBagAttribute(pkcs9_localKeyId, this.createSubjectKeyId(ct.getPublicKey()));
                }
                Enumeration e3 = bagAttrs2.getBagAttributeKeys();
                while (e3.hasMoreElements()) {
                    ASN1ObjectIdentifier oid3 = (ASN1ObjectIdentifier)e3.nextElement();
                    ASN1EncodableVector kSeq = new ASN1EncodableVector();
                    kSeq.add(oid3);
                    kSeq.add(new DERSet(bagAttrs2.getBagAttribute(oid3)));
                    attrSet = true;
                    kName.add(new DERSequence(kSeq));
                }
            }
            if (!attrSet) {
                ASN1EncodableVector kSeq = new ASN1EncodableVector();
                Certificate ct = this.engineGetCertificate(name);
                kSeq.add(pkcs9_localKeyId);
                kSeq.add(new DERSet(this.createSubjectKeyId(ct.getPublicKey())));
                kName.add(new DERSequence(kSeq));
                kSeq = new ASN1EncodableVector();
                kSeq.add(pkcs9_friendlyName);
                kSeq.add(new DERSet(new DERBMPString(name)));
                kName.add(new DERSequence(kSeq));
            }
            SafeBag kBag = new SafeBag(ckx_shroudedKeyBag, ASN1Primitive.fromByteArray(wrapKey), new DERSet(kName));
            keyS.add(kBag);
        }
        byte[] keySEncoded = new DERSequence(keyS).getEncoded("DER");
        BEROctetString keyString = new BEROctetString(keySEncoded);
        ASN1EncodableVector crlSeq = new ASN1EncodableVector();
        Enumeration crlbs = this.crls.keys();
        boolean hasCrl = false;
        while (crlbs.hasMoreElements()) {
            hasCrl = true;
            byte[] crlSalt = new byte[20];
            this.random.nextBytes(crlSalt);
            String name = (String)crlbs.nextElement();
            X509CRL x509crl = (X509CRL)this.crls.get(name);
            PKCS12PBEParams crlParams = new PKCS12PBEParams(crlSalt, 1024);
            AlgorithmIdentifier crlAlgId = new AlgorithmIdentifier(this.algorithm, crlParams.toASN1Primitive());
            CRLBag crlbagInfo = null;
            try {
                crlbagInfo = new CRLBag(ckx_crlBag, new DEROctetString(x509crl.getEncoded()));
            }
            catch (CRLException e4) {
                new CRLException(e4.toString());
            }
            boolean crlattrSet = false;
            ASN1EncodableVector crlName = new ASN1EncodableVector();
            if (x509crl instanceof PKCS12BagAttributeCarrier) {
                PKCS12BagAttributeCarrier bagAttrs3 = (PKCS12BagAttributeCarrier)((Object)x509crl);
                DERBMPString nm3 = (DERBMPString)bagAttrs3.getBagAttribute(pkcs9_friendlyName);
                if (nm3 == null || !nm3.getString().equals(name)) {
                    bagAttrs3.setBagAttribute(pkcs9_friendlyName, new DERBMPString(name));
                }
                if (bagAttrs3.getBagAttribute(pkcs9_localKeyId) == null) {
                    Certificate ct = this.engineGetCertificate(name);
                    bagAttrs3.setBagAttribute(pkcs9_localKeyId, this.createSubjectKeyId(ct.getPublicKey()));
                }
                e2 = bagAttrs3.getBagAttributeKeys();
                while (e2.hasMoreElements()) {
                    oid2 = (ASN1ObjectIdentifier)e2.nextElement();
                    ASN1EncodableVector crlS = new ASN1EncodableVector();
                    crlS.add(oid2);
                    crlS.add(new DERSet(bagAttrs3.getBagAttribute(oid2)));
                    crlName.add(new DERSequence(crlS));
                    crlattrSet = true;
                }
            }
            if (!crlattrSet) {
                ASN1EncodableVector crlS = new ASN1EncodableVector();
                Certificate ct = this.engineGetCertificate(name);
                crlS.add(pkcs9_localKeyId);
                crlS.add(new DERSet(this.createSubjectKeyId(ct.getPublicKey())));
                crlName.add(new DERSequence(crlS));
                crlS = new ASN1EncodableVector();
                crlS.add(pkcs9_friendlyName);
                crlS.add(new DERSet(new DERBMPString(name)));
                crlName.add(new DERSequence(crlS));
            }
            SafeBag crlsBag = new SafeBag(ckx_crlBag, crlbagInfo.toASN1Primitive(), new DERSet(crlName));
            crlSeq.add(crlsBag);
        }
        ASN1EncodableVector certSeq = new ASN1EncodableVector();
        AlgorithmIdentifier cAlgId = new AlgorithmIdentifier(this.algorithm, pbesParams.toASN1Primitive());
        Hashtable<Certificate, Certificate> doneCerts = new Hashtable<Certificate, Certificate>();
        Enumeration cs = this.keys.keys();
        while (cs.hasMoreElements()) {
            try {
                String name = (String)cs.nextElement();
                cert = this.engineGetCertificate(name);
                cAttrSet = false;
                cBag = new CertBag(x509Certificate, new DEROctetString(cert.getEncoded()));
                fName = new ASN1EncodableVector();
                if (cert instanceof PKCS12BagAttributeCarrier) {
                    bagAttrs = (PKCS12BagAttributeCarrier)((Object)cert);
                    nm = (DERBMPString)bagAttrs.getBagAttribute(pkcs9_friendlyName);
                    if (nm == null || !nm.getString().equals(name)) {
                        bagAttrs.setBagAttribute(pkcs9_friendlyName, new DERBMPString(name));
                    }
                    if (bagAttrs.getBagAttribute(pkcs9_localKeyId) == null) {
                        bagAttrs.setBagAttribute(pkcs9_localKeyId, this.createSubjectKeyId(cert.getPublicKey()));
                    }
                    e = bagAttrs.getBagAttributeKeys();
                    while (e.hasMoreElements()) {
                        oid = (ASN1ObjectIdentifier)e.nextElement();
                        fSeq2 = new ASN1EncodableVector();
                        fSeq2.add(oid);
                        fSeq2.add(new DERSet(bagAttrs.getBagAttribute(oid)));
                        fName.add(new DERSequence(fSeq2));
                        cAttrSet = true;
                    }
                }
                if (!cAttrSet) {
                    fSeq = new ASN1EncodableVector();
                    fSeq.add(pkcs9_localKeyId);
                    fSeq.add(new DERSet(this.createSubjectKeyId(cert.getPublicKey())));
                    fName.add(new DERSequence(fSeq));
                    fSeq = new ASN1EncodableVector();
                    fSeq.add(pkcs9_friendlyName);
                    fSeq.add(new DERSet(new DERBMPString(name)));
                    fName.add(new DERSequence(fSeq));
                }
                sBag = new SafeBag(ckx_certBag, cBag.toASN1Primitive(), new DERSet(fName));
                certSeq.add(sBag);
                doneCerts.put(cert, cert);
            }
            catch (CertificateEncodingException e5) {
                throw new IOException("Error encoding certificate: " + e5.toString());
            }
        }
        cs = this.certs.keys();
        while (cs.hasMoreElements()) {
            try {
                String certId = (String)cs.nextElement();
                cert = (Certificate)this.certs.get(certId);
                cAttrSet = false;
                if (this.keys.get(certId) != null) continue;
                cBag = new CertBag(x509Certificate, new DEROctetString(cert.getEncoded()));
                fName = new ASN1EncodableVector();
                if (cert instanceof PKCS12BagAttributeCarrier) {
                    bagAttrs = (PKCS12BagAttributeCarrier)((Object)cert);
                    nm = (DERBMPString)bagAttrs.getBagAttribute(pkcs9_friendlyName);
                    if (nm == null || !nm.getString().equals(certId)) {
                        bagAttrs.setBagAttribute(pkcs9_friendlyName, new DERBMPString(certId));
                    }
                    e = bagAttrs.getBagAttributeKeys();
                    while (e.hasMoreElements()) {
                        oid = (ASN1ObjectIdentifier)e.nextElement();
                        if (oid.equals(pkcs9_localKeyId)) continue;
                        fSeq2 = new ASN1EncodableVector();
                        fSeq2.add(oid);
                        fSeq2.add(new DERSet(bagAttrs.getBagAttribute(oid)));
                        fName.add(new DERSequence(fSeq2));
                        cAttrSet = true;
                    }
                }
                if (!cAttrSet) {
                    fSeq = new ASN1EncodableVector();
                    fSeq.add(pkcs9_friendlyName);
                    fSeq.add(new DERSet(new DERBMPString(certId)));
                    fName.add(new DERSequence(fSeq));
                }
                sBag = new SafeBag(ckx_certBag, cBag.toASN1Primitive(), new DERSet(fName));
                certSeq.add(sBag);
                doneCerts.put(cert, cert);
            }
            catch (CertificateEncodingException e6) {
                throw new IOException("Error encoding certificate: " + e6.toString());
            }
        }
        Set usedSet = this.getUsedCertificateSet();
        cs = this.chainCerts.keys();
        while (cs.hasMoreElements()) {
            try {
                CertId certId = (CertId)cs.nextElement();
                Certificate cert2 = (Certificate)this.chainCerts.get(certId);
                if (!usedSet.contains(cert2) || doneCerts.get(cert2) != null) continue;
                cBag = new CertBag(x509Certificate, new DEROctetString(cert2.getEncoded()));
                fName = new ASN1EncodableVector();
                if (cert2 instanceof PKCS12BagAttributeCarrier) {
                    bagAttrs = (PKCS12BagAttributeCarrier)((Object)cert2);
                    e2 = bagAttrs.getBagAttributeKeys();
                    while (e2.hasMoreElements()) {
                        oid2 = (ASN1ObjectIdentifier)e2.nextElement();
                        if (oid2.equals(pkcs9_localKeyId)) continue;
                        ASN1EncodableVector fSeq3 = new ASN1EncodableVector();
                        fSeq3.add(oid2);
                        fSeq3.add(new DERSet(bagAttrs.getBagAttribute(oid2)));
                        fName.add(new DERSequence(fSeq3));
                    }
                }
                sBag = new SafeBag(ckx_certBag, cBag.toASN1Primitive(), new DERSet(fName));
                certSeq.add(sBag);
            }
            catch (CertificateEncodingException e7) {
                throw new IOException("Error encoding certificate: " + e7.toString());
            }
        }
        byte[] certSeqEncoded = new DERSequence(certSeq).getEncoded("DER");
        byte[] certBytes = this.cryptData(true, cAlgId, password, certSeqEncoded);
        EncryptedData cInfo = new EncryptedData(data, cAlgId, new BEROctetString(certBytes));
        LinkedList<ContentInfo> infoList = new LinkedList<ContentInfo>();
        if (keyS.size() > 0) {
            infoList.add(new ContentInfo(data, keyString));
        }
        if (certSeq.size() > 0) {
            infoList.add(new ContentInfo(encryptedData, cInfo.toASN1Primitive()));
        }
        if (hasCrl) {
            byte[] CrlEncoded = new DERSequence(crlSeq).getEncoded("DER");
            BEROctetString CrlString = new BEROctetString(CrlEncoded);
            infoList.add(new ContentInfo(data, CrlString));
        }
        if (!this.duoList.isEmpty()) {
            DERSequence safeContents = this.handleSafeContents(algId, password);
            byte[] bytes = this.cryptData(true, algId, password, safeContents.getEncoded("DER"));
            EncryptedData encryptedData = new EncryptedData(data, cAlgId, new BEROctetString(bytes));
            infoList.add(new ContentInfo(GMObjectIdentifiers.encryptedData, encryptedData.toASN1Primitive()));
        }
        ContentInfo[] info = infoList.toArray(new ContentInfo[0]);
        AuthenticatedSafe auth = new AuthenticatedSafe(info);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream asn1Out = useDEREncoding ? ASN1OutputStream.create(bOut, "DER") : new BEROutputStream(bOut);
        asn1Out.writeObject(auth);
        byte[] pkg = bOut.toByteArray();
        ContentInfo mainInfo = new ContentInfo(data, new BEROctetString(pkg));
        byte[] mSalt = new byte[this.saltLength];
        this.random.nextBytes(mSalt);
        try {
            byte[] res = this.calculateHMac(macAlgorithm.getAlgorithm(), mSalt, this.itCount, password, pkg);
            DigestInfo dInfo = new DigestInfo(macAlgorithm, res);
            mData = new MacData(dInfo, mSalt, this.itCount);
        }
        catch (Exception e8) {
            throw new IOException("error constructing MAC: " + e8.toString());
        }
        Ckx ckx = new Ckx(mainInfo, mData);
        ckx.encodeTo(stream, "DER");
    }

    private DERSequence handleSafeContents(AlgorithmIdentifier algId, char[] password) throws IOException {
        ASN1EncodableVector scV = new ASN1EncodableVector();
        for (DuoPair duoPair : this.duoList) {
            duoPair.checkMatch();
            ASN1EncodableVector pairV = new ASN1EncodableVector();
            String signAlias = duoPair.getSignAlias();
            if (signAlias == null) {
                signAlias = UUID.randomUUID().toString();
            }
            ASN1EncodableVector signSC = new ASN1EncodableVector();
            SafeBag signKBag = this.handleDuoShroudedKeyBag(algId, password, signAlias, duoPair.getSignKey(), duoPair.getSignCert());
            signSC.add(signKBag);
            SafeBag signCBag = this.handleDuoCertBag(signAlias, duoPair.getSignCert());
            signSC.add(signCBag);
            SafeBag scSign = new SafeBag(ckx_safeContentBag, new DERSequence(signSC));
            pairV.add(scSign);
            String encAlias = duoPair.getEncAlias();
            if (encAlias == null) {
                encAlias = UUID.randomUUID().toString();
            }
            ASN1EncodableVector encSC = new ASN1EncodableVector();
            SafeBag encKBag = this.handleDuoShroudedKeyBag(algId, password, encAlias, duoPair.getEncKey(), duoPair.getEncCert());
            encSC.add(encKBag);
            SafeBag encCBag = this.handleDuoCertBag(encAlias, duoPair.getEncCert());
            encSC.add(encCBag);
            SafeBag scEnc = new SafeBag(ckx_safeContentBag, new DERSequence(encSC));
            pairV.add(scEnc);
            scV.add(new DERSequence(pairV));
        }
        return new DERSequence(scV);
    }

    private SafeBag handleDuoShroudedKeyBag(AlgorithmIdentifier algId, char[] password, String alias, PrivateKey privKey, Certificate cert) throws IOException {
        byte[] wrapKey = this.wrapKey(privKey, algId, password);
        ASN1EncodableVector kName = new ASN1EncodableVector();
        if (privKey instanceof PKCS12BagAttributeCarrier) {
            PKCS12BagAttributeCarrier bagAttrs = (PKCS12BagAttributeCarrier)((Object)privKey);
            bagAttrs.setBagAttribute(pkcs9_friendlyName, new DERBMPString(alias));
            bagAttrs.setBagAttribute(pkcs9_localKeyId, this.createSubjectKeyId(cert.getPublicKey()));
            Enumeration e = bagAttrs.getBagAttributeKeys();
            while (e.hasMoreElements()) {
                ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)e.nextElement();
                ASN1EncodableVector kSeq = new ASN1EncodableVector();
                kSeq.add(oid);
                kSeq.add(new DERSet(bagAttrs.getBagAttribute(oid)));
                kName.add(new DERSequence(kSeq));
            }
        }
        return new SafeBag(ckx_shroudedKeyBag, ASN1Primitive.fromByteArray(wrapKey), new DERSet(kName));
    }

    private SafeBag handleDuoCertBag(String alias, Certificate cert) throws IOException {
        try {
            CertBag cBag = new CertBag(x509Certificate, new DEROctetString(cert.getEncoded()));
            ASN1EncodableVector fName = new ASN1EncodableVector();
            if (cert instanceof PKCS12BagAttributeCarrier) {
                PKCS12BagAttributeCarrier bagAttrs = (PKCS12BagAttributeCarrier)((Object)cert);
                bagAttrs.setBagAttribute(pkcs9_friendlyName, new DERBMPString(alias));
                bagAttrs.setBagAttribute(pkcs9_localKeyId, this.createSubjectKeyId(cert.getPublicKey()));
                Enumeration e = bagAttrs.getBagAttributeKeys();
                while (e.hasMoreElements()) {
                    ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)e.nextElement();
                    ASN1EncodableVector fSeq = new ASN1EncodableVector();
                    fSeq.add(oid);
                    fSeq.add(new DERSet(bagAttrs.getBagAttribute(oid)));
                    fName.add(new DERSequence(fSeq));
                }
            }
            return new SafeBag(ckx_certBag, cBag.toASN1Primitive(), new DERSet(fName));
        }
        catch (CertificateEncodingException e) {
            throw new IOException("Error encoding certificate: " + e.toString());
        }
    }

    private Q5PBESParameters createPBESParameters() {
        byte[] slat = new byte[20];
        this.random.nextBytes(slat);
        Q5PBKDFParams q5PBKDFParams = new Q5PBKDFParams(slat, this.itCount);
        KeyDerivationFunc keyDerivationFunc = new KeyDerivationFunc(id_PBKDF, q5PBKDFParams);
        EncryptionScheme encryptionScheme = null;
        try {
            AlgorithmParameterGenerator paramGen = this.helper.createAlgorithmParameterGenerator(sms4_cbc.getId());
            AlgorithmParameters params = paramGen.generateParameters();
            encryptionScheme = new EncryptionScheme(sms4_cbc, ASN1Primitive.fromByteArray(params.getEncoded()));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new Q5PBESParameters(keyDerivationFunc, encryptionScheme);
    }

    private Set getUsedCertificateSet() {
        String alias;
        HashSet<Certificate> usedSet = new HashSet<Certificate>();
        Enumeration en = this.keys.keys();
        while (en.hasMoreElements()) {
            alias = (String)en.nextElement();
            Certificate[] certs = this.engineGetCertificateChain(alias);
            for (int i = 0; i != certs.length; ++i) {
                usedSet.add(certs[i]);
            }
        }
        en = this.certs.keys();
        while (en.hasMoreElements()) {
            alias = (String)en.nextElement();
            Certificate cert = this.engineGetCertificate(alias);
            usedSet.add(cert);
        }
        return usedSet;
    }

    private byte[] calculateHMac(ASN1ObjectIdentifier oid, byte[] salt, int itCount, char[] password, byte[] data) throws Exception {
        PBEParameterSpec defParams = new PBEParameterSpec(salt, itCount);
        Mac mac = this.helper.createMac(oid.getId());
        mac.init(new PKCS12Key(password), defParams);
        mac.update(data);
        return mac.doFinal();
    }

    private synchronized Provider getBouncyCastleProvider() {
        if (Security.getProvider("INFOSEC") != null) {
            this.provider = Security.getProvider("INFOSEC");
        } else if (this.provider == null) {
            this.provider = new INFOSECProvider();
        }
        return this.provider;
    }

    private static class DefaultSecretKeyProvider {
        private final Map<ASN1ObjectIdentifier, Integer> KEY_SIZES;

        DefaultSecretKeyProvider() {
            HashMap<ASN1ObjectIdentifier, Integer> keySizes = new HashMap<ASN1ObjectIdentifier, Integer>();
            keySizes.put(GMObjectIdentifiers.sms4_cbc, Integers.valueOf(128));
            this.KEY_SIZES = Collections.unmodifiableMap(keySizes);
        }

        public int getKeySize(AlgorithmIdentifier algorithmIdentifier) {
            Integer keySize = this.KEY_SIZES.get(algorithmIdentifier.getAlgorithm());
            if (keySize != null) {
                return keySize;
            }
            return -1;
        }
    }

    private static class IgnoresCaseHashtable {
        private Hashtable orig = new Hashtable();
        private Hashtable keys = new Hashtable();

        private IgnoresCaseHashtable() {
        }

        public void put(String key, Object value) {
            String lower = key == null ? null : Strings.toLowerCase(key);
            String k = (String)this.keys.get(lower);
            if (k != null) {
                this.orig.remove(k);
            }
            this.keys.put(lower, key);
            this.orig.put(key, value);
        }

        public Enumeration keys() {
            return this.orig.keys();
        }

        public Object remove(String alias) {
            String k = (String)this.keys.remove(alias == null ? null : Strings.toLowerCase(alias));
            if (k == null) {
                return null;
            }
            return this.orig.remove(k);
        }

        public Object get(String alias) {
            String k = (String)this.keys.get(alias == null ? null : Strings.toLowerCase(alias));
            if (k == null) {
                return null;
            }
            return this.orig.get(k);
        }

        public Enumeration elements() {
            return this.orig.elements();
        }
    }

    private class CertId {
        byte[] id;

        CertId(PublicKey key) {
            this.id = CKXKeyStore.this.createSubjectKeyId(key).getKeyIdentifier();
        }

        CertId(byte[] id) {
            this.id = id;
        }

        public int hashCode() {
            return Arrays.hashCode(this.id);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CertId)) {
                return false;
            }
            CertId cId = (CertId)o;
            return Arrays.areEqual(this.id, cId.id);
        }
    }
}

